//
// C++ Interface: SQLiteConnection
//
// Description: 
//
//
// Author: Andreas Scherf <scherfa@web.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SQLITECONNECTION_H
#define SQLITECONNECTION_H

#include "DBConnection.h"

// SQLite
#include "./sqlite/sqlite3.h"

/**
	@author Andreas Scherf <scherfa@web.de>
*/
class SQLiteConnection : public DBConnection
{
	public:
 		SQLiteConnection(  /*SqliteConfig* config */ );
        virtual ~SQLiteConnection();
		virtual void connect ();
		virtual void disconnect();
		virtual bool startTransaction();
		virtual bool commitTransaction();
		virtual bool rollbackTransaction();
        
		virtual int query(KRunningObject *pObject,KRunningResultSet *pResultSet );
        virtual int insert( const QString& /* statement */, const QString& /* table */ );
        bool isConnected()const { return true; }
        virtual QString getDBVersion();
		void setConnectionParameter(const QString &sFilename);
		// SQLite
		virtual QString getDatabaseName(){return m_sDBName;}
		virtual bool createInitialTable(KRunningTableObject* pTable);
		virtual bool insertValues(KRunningObject *pKRunningObject);
		virtual bool updateValues(KRunningObject *pKRunningObject,const QString& sFilter=QString::null);
		virtual bool deleteValues(KRunningObject *pKRunningObject);
		virtual QString getTableRows(const QString& sTablename);
	protected:
		bool createTable(const QString& sTable);
		virtual long getTableCount();
		QString createSQLStatement(KRunningObject*pObject);
    private:
		QStringList getTableNames();
    
        sqlite3* m_pDB;
		QString m_sFilename;
};

#endif
