/*  KRunning - TeamEdit.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai 20 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef TEAMEDIT_H
#define TEAMEDIT_H

#include "TeamsEditGUI.h"
#include "DBConnection.h"
#include "Printing.h"
#include "krunning.h"
// QT Stuff
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
//#include <qdatatable.h>
//#include <qsqlform.h>
#include <qpushbutton.h>
#include <qpopupmenu.h>
// KDE Stuff
#include <kprinter.h>
#include <kdialog.h>
#include <kmessagebox.h>
#include <klistview.h>
//DEBUG
#include <sstream>

class TeamEdit : public TeamsEditGUI
{
        Q_OBJECT

    public:
        TeamEdit (QWidget * parent = 0, const char *name = 0);
        virtual ~ TeamEdit ();
        void setDefaultSettings();
        void print(KPrinter *printer);
    protected slots: // Protected slots
        void slotNewTeam();
        void slotTeamRenamed(QListViewItem *,const QString &,int);
        void slotShowPopupMenu(QListViewItem* item,const QPoint & point,int col);
        void slotDeleteSelectedTeam();
    protected:

    private:
        QPopupMenu * teamPopupMenu;

};

class TeamListItem : public KListViewItem
{
    public:
        TeamListItem( KListView *parent, KRunningTeamObject *to );
        KRunningTeamObject *team() { return teamobj; }
        int compare( QListViewItem * i, int col, bool ascending ) const;
    protected:
        KRunningTeamObject *teamobj;
};

#endif // TEAMEDIT_H
