/*  KRunning - Time.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai 6 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef TIMECOUNT_H
#define TIMECOUNT_H TIMECOUNT_H

#include <qlineedit.h>
#include <qlistbox.h>
#include <qpopupmenu.h>
// IO
#include <fstream>
#include <qdir.h>

#include <krestrictedline.h>

#include "Preferences.h"
#include "TimeGUI.h"
#include "DigitalClock.h"
#include "DBConnection.h"

#include "krunning.h"


class Time : public TimeGUI
{
        Q_OBJECT
    public:
        Time (QWidget * parent = 0, const char *name = 0);
        virtual ~ Time ();
        void setFilename(const QString & name);
        void setStartTime (const QTime & time);
        void setDefaultSettings();
    protected:
        void            keyPressEvent (QKeyEvent *);
        void mousePressEvent(QMouseEvent *);
    protected slots:
        void showPopupMenu(QListViewItem*,const QPoint &,int);
        void deleteSelectedTime();
        void slotShowFullScreen();
    private:
        uint getRTLCode (const QTime & t);
        uint getSeconds (const QTime & t);
        void setTimeList();
        QString m_sFilename;
        int m_nTimesum;
        QPopupMenu  * m_pPopupMenu;
        QPopupMenu  * m_pFullScreenMenu;
        bool m_bFullScreen;
        Time *m_pTime;
};

class TimeViewItem : public KListViewItem
{
    public:
        // TimeListItem( KListView *parent, timeObj *to );
        //   TimeListItem( KListView *parent,timeObj *timeobj,runnerObj *runnerobj );
        TimeViewItem (KListView *parent,const QTime & time,const QString& sFormat,int number = 0);
        int compare( QListViewItem * i, int col, bool ascending ) const;
    protected:


};

#endif // TIMECOUNT_H
