/*  KRunning - UITools.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Aug 12 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef UITOOLS_H
#define UITOOLS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 
// KDE Stuff
#include <klistbox.h>
// QTStuff
#include <qpainter.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qhbox.h>
#include <qpushbutton.h>



class MainIconListBox : public KListBox {
    public:
        MainIconListBox( QWidget *parent=0, const char *name=0, WFlags f=0 );
        void updateMinimumHeight();
        void updateWidth();
        void invalidateHeight();
        void invalidateWidth();
        void setShowAll( bool showAll );

    private:
        bool mShowAll;
        bool mHeightValid;
        bool mWidthValid;
};

class MainIconListItem : public QListBoxItem {
    public:
        MainIconListItem( QListBox *listbox, const QPixmap &pixmap,
                          const QString &text,int idx );
        virtual int height( const QListBox *lb ) const;
        virtual int width( const QListBox *lb ) const;
        int expandMinimumWidth( int width );
        int getIndex();
    protected:
        const QPixmap &defaultPixmap();
        void paint( QPainter *painter );

    private:
        QPixmap mPixmap;
        int mMinimumWidth;
        int index;
};


#endif // UITOOLS_H    
