/*  KRunning - krunning.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai  6 11:16:42 CEST 2002 write to scherfa@web.de if you found a bug.
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef KRUNNING_H
#define KRUNNING_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt

// include files for KDE
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <kurl.h>
#include <klocale.h>
#include <kstddirs.h>

// forward declaration of the KRunning classes

#include "DBConnection.h"
#include "CreateTables.h"
// DEBUG Output

#include <iostream>

class KRunningDoc;
class KRunningView;

/**
  * The base class for KRunning application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KRunningView creates your center view, which is connected
  * to the window's Doc object.
  * KRunningApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class KRunningApp : public KMainWindow
{
        Q_OBJECT

        friend class KRunningView;

    public:
        /** construtor of KRunningApp, calls all init functions to create the application.
         */
        KRunningApp(QWidget* parent=0, const char* name=0);
        ~KRunningApp();
        /** opens a file specified by commandline option
         */
        void openDocumentFile(const KURL& url=0);
        /** returns a pointer to the current document connected to the KTMainWindow instance and is used by
         * the View class to access the document object's methods
         */	
        KRunningDoc *getDocument() const;

    protected:
        /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
         * file
         */ 	
        void saveOptions();
        /** read general Options again and initialize all variables like the recent file list
         */
        void readOptions();
        /** initializes the KActions of the application */
        void initActions();
        /** sets up the statusbar for the main window by initialzing a statuslabel.
         */
        void initStatusBar();
        /** initializes the document object of the main window that is connected to the view in initView().
         * @see initView();
         */
        void initDocument();
        /** creates the centerwidget of the KTMainWindow instance and sets it as the view
         */
        void initView();
        /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
         * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
         * be saved if Modified; on cancel the closeEvent is rejected.
         * @see KTMainWindow#queryClose
         * @see KTMainWindow#closeEvent
         */
        virtual bool queryClose();
        /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
         * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
         * properties.
         * @see KTMainWindow#queryExit
         * @see KTMainWindow#closeEvent
         */
        virtual bool queryExit();
        /** saves the window properties for each open window during session end to the session config file, including saving the currently
         * opened file by a temporary filename provided by KApplication.
         * @see KTMainWindow#saveProperties
         */
        virtual void saveProperties(KConfig *_cfg);
        /** reads the session config file and restores the application's state including the last opened files and documents by reading the
         * temporary files saved by saveProperties()
         * @see KTMainWindow#readProperties
         */
        virtual void readProperties(KConfig *_cfg);
        /** reads the database and inserts the created events into the main ToolBar
        */
        void initEventSelector();
    protected slots:
        void mainEventActivated(const QString& newEvent );
    public slots:
        /** opens a file from the recent files menu */
        void slotFileOpenRecent(const KURL& url);
        /** save a document */
        void slotFileSave();
        /** save a document by a new filename*/
        void slotFileSaveAs();
        /** asks for saving if the file is modified, then closes the actual file and window*/
        void slotFileClose();
        /** print the actual file */
        void slotFilePrint();
        /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
         * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
         */
        void slotFileQuit();
        /** toggles the toolbar
         */
        void slotViewToolBar();
        /** toggles the statusbar
         */
        void slotViewStatusBar();
        /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
         * @param text the text that is displayed in the statusbar
         */
        void slotStatusMsg(const QString &text);
        /** Opens the Prefernces Dialog
        @param text which would be displayed on top of the dialog
        */
        void slotPreferencesWindow();
        void slotEditTables();

        void slotConnectDB();
        void slotDisconnectDB();
        void slotMergeDB();
        void slotExportHTML();
        void slotImportTimes();
        void slotExportTimes();
        void slotExportTeams();
        void slotImportTeams();
    private:
        /** the configuration object of the application */
        KConfig *config;
        /** view is the main widget which represents your working area. The View
         * class should handle all events of the view widget.  It is kept empty so
         * you can create your view according to your application's needs by
         * changing the view class.
         */
        KRunningView *view;
        /** doc represents your actual document and is created only once. It keeps
         * information such as filename and does the serialization of your files.
         */
        KRunningDoc *doc;

        // KAction pointers to enable/disable actions
        KAction* connectDB;
        KAction* disconnectDB;

        KAction* mergeDB;
        //    KAction* fileOpen;
        //  KRecentFilesAction* fileOpenRecent;
        KAction* fileSave;
        KAction* fileSaveAs;

        KAction* filePrint;
        KAction* fileQuit;

        KAction* preferencesWindow;
        KAction* editTables;
        KActionMenu* exportFile;
        KActionMenu* importFile;
        KAction *fileImportTimes;
        KAction *fileExportTimes;
        KAction *fileExportHTML;
        KAction *fileExportTeams;
        KAction *fileImportTeams;

        KToggleAction* viewToolBar;
        KToggleAction* viewStatusBar;

        CreateTables *m_pCreateTables;

};

class timeImportDialog : public KDialogBase
{
        Q_OBJECT
    public:
        timeImportDialog (QWidget *parent, const char *name,const KURL & url);
        ~timeImportDialog();
    private:
        QComboBox * eventComboBox;
        QLabel *label;
        KURL filepath;
    protected slots:
        void ok();
};

class timeExportDialog : public KDialogBase
{
        Q_OBJECT
    public:
        timeExportDialog (QWidget *parent, const char *name,const KURL & url);
        ~timeExportDialog();
    private:
        QComboBox * eventComboBox;
        QLabel *label;
        KURL filepath;
    protected slots:
        void ok();
};


#endif // KRUNNING_H
