/*  KRunning - krunningdoc.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai  6 11:16:42 CEST 2002 write to scherfa@web.de if you found a bug.
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
// include files for Qt
#include <qdir.h>
#include <qwidget.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kio/job.h>
#include <kio/netaccess.h>

// application specific includes
#include "krunningdoc.h"
#include "krunning.h"
#include "krunningview.h"

QList<KRunningView> *KRunningDoc::pViewList = 0L;

KRunningDoc::KRunningDoc(QWidget *parent, const char *name) : QObject(parent, name)
{
    if(!pViewList)
    {
        pViewList = new QList<KRunningView>();
    }

    pViewList->setAutoDelete(true);
}

KRunningDoc::~KRunningDoc()
{
}

void KRunningDoc::addView(KRunningView *view)
{
    pViewList->append(view);
}

void KRunningDoc::removeView(KRunningView *view)
{
    pViewList->remove(view);
}
void KRunningDoc::setURL(const KURL &url)
{
    doc_url=url;
}

const KURL& KRunningDoc::URL() const
{
    return doc_url;
}

void KRunningDoc::slotUpdateAllViews(KRunningView *sender)
{
    KRunningView *w;
    if(pViewList)
    {
        for(w=pViewList->first(); w!=0; w=pViewList->next())
        {
            if(w!=sender)
                w->repaint();
        }
    }

}

bool KRunningDoc::saveModified()
{
    bool completed=true;

    if(modified)
    {
        KRunningApp *win=(KRunningApp *) parent();
        int want_save = KMessageBox::warningYesNoCancel(win,
                        i18n("The current file has been modified.\n"
                             "Do you want to save it?"),
                        i18n("Warning"));
        switch(want_save)
        {
        case KMessageBox::Yes:
            if (doc_url.fileName() == i18n("Untitled"))
            {
                win->slotFileSaveAs();
            }
            else
            {
                saveDocument(URL());
            };

            deleteContents();
            completed=true;
            break;

        case KMessageBox::No:
            setModified(false);
            deleteContents();
            completed=true;
            break;

        case KMessageBox::Cancel:
            completed=false;
            break;

        default:
            completed=false;
            break;
        }
    }

    return completed;
}

void KRunningDoc::closeDocument()
{
    deleteContents();
}

bool KRunningDoc::newDocument()
{
    /////////////////////////////////////////////////
    // TODO: Add your document initialization code here
    /////////////////////////////////////////////////
    modified=false;
    doc_url.setFileName(i18n("Untitled"));

    return true;
}

bool KRunningDoc::openDocument(const KURL& url, const char *format /*=0*/)
{
    /*parentWidget()->setCaption(url.prettyURL());
    m_view->openURL(url);*/

    modified=false;
    return url.isValid();
}

bool KRunningDoc::saveDocument(const KURL& url, const char *format /*=0*/)
{
    /////////////////////////////////////////////////
    // TODO: Add your document saving code here
    /////////////////////////////////////////////////
	
    modified=false;
    return url.isValid();
}

void KRunningDoc::deleteContents()
{
    /////////////////////////////////////////////////
    // TODO: Add implementation to delete the document contents
    /////////////////////////////////////////////////

}
