/*  KRunning - krunningview.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai  6 11:16:42 CEST 2002 write to scherfa@web.de if you found a bug.
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef KRUNNINGVIEW_H
#define KRUNNINGVIEW_H KRUNNINGVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>
#include <qlayout.h>
#include <qwidgetstack.h>
// include files for KDE
#include <kprinter.h>
#include <kiconview.h>
#include <kiconloader.h>
#include <kfiledialog.h>

// Widgets
#include "TeamEdit.h"
#include "RunnerEdit.h"
#include "EventView.h"
#include "ShowRunner.h"
#include "Time.h"
#include "PositionControl.h"
#include "Evaluation.h"
#include "Certification.h"
#include "UITools.h"
// Database stuff
#include "DBConnection.h"

class KRunningDoc;
class Time;
/** The KRunningView class provides the view widget for the KRunningApp instance.
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KRunningView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KRunningApp class to manipulate and display
 * the document structure provided by the KRunningDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KRunningView : public QWidget
{
        Q_OBJECT

    public:
        enum widgetId {   // Dont forget to update Names too (in the same direction)
            eventViewWidgetId=0,
            teamEditWidgetId,
            runnerEditWidgetId,
            timeCountWidgetId,
            positionControlWidgetId,
            evaluationWidgetId,
            showRunnerWidgetId,
            certificationWidgetId
    };
        /** Constructor for the main view */
        KRunningView(QWidget *parent = 0, const char *name=0);
        /** Destructor for the main view */
        ~KRunningView();
        /** returns a pointer to the document connected to the view instance. Mind that this method requires a KRunningApp instance as a parent
         * widget to get to the window document pointer by calling the KRunningApp::getDocument() method.
         *
         * @see KRunningApp#getDocument
         */
        KRunningDoc *getDocument() const;

        /** contains the implementation for printing functionality */
        void print(KPrinter *pPrinter);
        /** contains the implementation of exporting datas (HTML,txt, ...) */
        void exportFile(const char *format =0);

        /** */
        void initMainWindow();
        void setEnabled (bool enabled);

    public slots:
        void globalEventChanged();
        void slotFillEventToolBar();
        void dbDisconnected();
    protected:
        MainIconListBox* mainIconBox;
    protected slots:
        // void slotDocumentChanged();
        void onSelectModule( QListBoxItem *item );
    private:
        QGridLayout* mainGridLayout;
        QWidgetStack *mainContentWidget;
        void addOptionsToIconView();
        // Widgets
        TeamEdit *teamEditWidget;
        RunnerEdit *runnerEditWidget;
        EventView *eventViewWidget;
        ShowRunner *showRunnerWidget;
        Time *timeCountWidget;
        PositionControl *positionControlWidget;
        Evaluation *evaluationWidget;
        Certification *certificationWidget;
        void createConnections(EventView *e );
};

#endif // KRUNNINGVIEW_H
