/*  KRunning - main.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai  6 11:16:42 CEST 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include <qmessagebox.h>

#include "krunning.h"

using namespace std;

static const char *description =
    I18N_NOOP("KRunning is a database for running events");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE


static KCmdLineOptions options[] =
    {
        { "+[File]", I18N_NOOP("file to open"), 0 },
        { 0, 0, 0 }
        // INSERT YOUR COMMANDLINE OPTIONS HERE
    };

int main(int argc, char *argv[])
{
#ifdef DEBUG
    cerr <<    KGlobal::locale()->defaultLanguage() << endl;
#endif
    KAboutData aboutData( "krunning", I18N_NOOP("KRunning"),
                          VERSION, description, KAboutData::License_GPL,
                          "(c) 2002-2007, Andreas Scherf",0,"http://krunning.sourceforge.net",0);
    aboutData.addAuthor("Andreas Scherf",I18N_NOOP("Idea and Programming"), "scherfa@web.de",0);
    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

    KApplication app;

    if (app.isRestored())
    {
        RESTORE(KRunningApp);
    }
    else
    {
        KRunningApp *krunning = new KRunningApp();
        krunning->show();

        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        if (args->count())
        {
            krunning->openDocumentFile(args->arg(0));
        }
        else
        {
            krunning->openDocumentFile();
        }
        args->clear();
    }
    return app.exec();
}
