/***************************************************************************
 *   Copyright (C) 2005 by Oleg Martemjanov                                *
 *   demogorgorn@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
После продолжительного перерыва, несколько месяцев, увидела свет новая версия, 0.3, программы
KHTMLOrganizer, правда, с новым названием - WebPageIndexer, которое должно правильнее отражать задачи, которые программа выполняет - организует более простую работу с html коллекциями, индексирует сохранённые веб-странички, а также переименовывает эти документы, согласно данным, полученным из тегов.

Новая версия может похвастаться новыми возможностями, новым интерфейсом, большим числом настроек, необходимых для более удобной работы с программой и т.д.

P.S. Для пользователей Debian и Fedora, которые собирают программы из исходных текстов, добавлены скрипты, с помощью которых они с лёгкостью могут собрать пакеты для своего дистрибутива. Для более подробной инфомации - читайте файл INSTALL или документацию на сайте.

Сайт программы - http://wpi.sourceforge.net
Kde-Apps.org - www.kde-apps.org/...
Скриншоты - http://wpi.sourceforge.net/screenshots.php
*/  
 
#include "webpageindexer.h"
#include "indextab.h"
#include "renametab.h"
#include "optionsdialog.h"

#include <qwidgetstack.h>

#include <kmainwindow.h>
#include <klocale.h>
#include <kstatusbar.h>
#include <kactionclasses.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kstdaccel.h>
#include <ktip.h>

WebPageIndexer::WebPageIndexer()
    : KMainWindow( 0, "WebPageIndexer" )
{
    setXMLFile("webpageindexerui.rc");

	statusBar()->show();  
	
	wi = new QWidgetStack(this);
	setCentralWidget( wi );
	
	IndexTab *in = new IndexTab(this);
	wi->addWidget(in,0);
	
	RenameTab *re = new RenameTab(this);
	wi->addWidget(re,1);
	
// 	wi->raiseWidget( 1 );
    
	setupActions();
	
	createGUI();
	
	setAutoSaveSettings();
}

WebPageIndexer::~WebPageIndexer()
{
}

void WebPageIndexer::setupActions()
{
	KStdAction::preferences(this, SLOT(slotShowOptions()), actionCollection())->setWhatsThis(i18n("Preferences of WebPageIndexer."));
	
	KAction *showIndexTabAct = new KAction(i18n("&Index Mode"), "launch",
                               KStdAccel::shortcut(KStdAccel::New),
                               this, SLOT(slotShowIndexTab()),
                               actionCollection(), "indexmode");
			       
	KAction *showRenameTabAct = new KAction(i18n("&Rename Mode"), "launch",
                               KStdAccel::shortcut(KStdAccel::Save),
                               this, SLOT(slotShowRenameTab()),
                               actionCollection(), "renamemode");
			       
	KStdAction::tipOfDay(this, SLOT(slotHelpTip()),
	actionCollection())->setWhatsThis(i18n("Show useful tips on the usage of application."));

}

void WebPageIndexer::slotShowOptions()
{
	OptionsDialog *optDia = new OptionsDialog(this);
	optDia->exec();
	delete optDia;

}

void WebPageIndexer::slotShowIndexTab()
{
	wi->raiseWidget(0);
}

void WebPageIndexer::slotShowRenameTab()
{
	wi->raiseWidget(1);
}

void WebPageIndexer::slotHelpTip()
{
	KTipDialog::showTip(this,QString::null, true );
}
 
#include "webpageindexer.moc"

