#!/bin/sh

# install script for the XChat2 SysTray Integration Plugin by Hetfield
# usage: sh install.sh --prefix=$prefix of xchat or wherever else
#
# If someone wonders about the license: This stuff is public domain
# by Marcus von Appen :-). Feel free to use it however you want.
# Send comments, questions, whatever else to marcus [at] syfault.org

expres=`echo $1 | awk -F "=" '{print $1}'`

if `test "$expres" != "--prefix"`; then
    echo ""
    echo "Usage: ./install.sh --prefix=DIR"
    echo ""
    echo "DIR should be the xchat installation prefix,"
    echo "else it will get installed into \$prefix/lib/xchat/plugins"
    exit
fi
    
case `uname` in
    *FreeBSD*) 
	MAKE=gmake;; # maybe change that later to gnu make
    *Linux*)
	MAKE=make;;
    *NetBSD*)
	MAKE=gmake;; # untested
    *OpenBSD*)
	MAKE=gmake;; # untested
esac

prefix=`echo $1 | awk -F "=" '{print $2}'`

$MAKE prefix=$prefix install
