/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ADVANCEDSEARCHDIALOG_H
#define ADVANCEDSEARCHDIALOG_H

#include <kdialogbase.h>

#include "datatablesearch.h"

class KLineEdit;
class KTextEdit;
class KPushButton;
class QCheckBox;
class QGroupBox;
class QRadioButton;
class SearchLine;
class AdvancedLine;

class AdvancedSearchDialog : public KDialogBase
{
    Q_OBJECT

public:
    struct Result
    {
        DialogCode result;
        DataTableSearch search;
        QString dataTableName;
    };

    AdvancedSearchDialog( DataTableList dataTables,
                          const DataTableSearch &defaultSearch =
                              DataTableSearch( DataTableSearch::MatchAny, DataTableSearch::Advanced ),
                          QWidget *parent = 0,
                          const char *name = 0 );

    virtual ~AdvancedSearchDialog();

public slots:
    Result exec();

signals:
    void saveSearchAs( const QString &name, const DataTableSearch &search );

protected slots:
    void saveToggled( bool toggle );
    virtual void accept();
    virtual void clear();
    virtual void more();
    virtual void fewer();
    virtual void custom();

private:
    void updateButtons();

    QWidget *m_criteria;
    DataTableList m_dataTables;
    DataTableSearch m_search;
    QString m_dataTableName;
    QValueList<SearchLine *> m_searchLines;
    QValueList<AdvancedLine *> m_advancedLines;
    QCheckBox *m_saveCheckBox;
    KLineEdit *m_dataTableNameLineEdit;
    QRadioButton *m_matchAnyButton;
    QRadioButton *m_matchAllButton;
    KPushButton *m_moreButton;
    KPushButton *m_fewerButton;
    QWidget *m_advanced;
    KPushButton *m_advancedButton;
};

#endif
