/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef DATASEARCHPOPUP_H
#define DATASEARCHPOPUP_H

#include <kdialogbase.h>

#include "datatablesearch.h"

class QFrame;
class FormLayout;
class QVBoxLayout;
class DataTable;
class DataEditorBase;

class DataSearchPopup : public KDialogBase
{
    Q_OBJECT
public:
    struct Result
    {
        DialogCode result;
        DataTableSearch::ComponentList components;
    };

    DataSearchPopup( const DataTableSearch::ComponentList &components,
                     DataTableSearch::SearchLevel level,
                     QWidget *parent = 0, const char *name = 0 );

    virtual ~DataSearchPopup();

public slots:
    Result exec();

signals:

protected slots:
    virtual void accept();

private:
    void addAdvancedPrompts();
    void addCustomPrompts();
    void addPromptsFromCustomQuery( DataTable *dataTable, const QString &query );
    void resolveAdvancedPrompts();
    void resolveCustomPrompts();
    void resolvePromptsFromCustomQuery( const DataTableSearch::Component &component,
                                        const QString &query );

    QString valueFromEditor( DataEditorBase *base );

private:
    FormLayout *m_formLayout;
    QFrame *m_formBox;
    DataTableSearch::ComponentList m_originals;
    DataTableSearch::ComponentList m_updates;
    QMap< QString, DataEditorBase* > m_editors;
    DataTableSearch::SearchLevel m_level;
};

#endif
