/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATATABLESPLITTER_H
#define DATATABLESPLITTER_H

#include <kfiledialog.h>

#include <qwidgetstack.h>

#include "datatablebox.h"

class KActionMenu;
class KDirWatch;
class SearchWidget;
class HistoryDataTable;
class DataTableInterface;

/**
 * This is the main layout class of DataKiosk.  It should contain a DataTableBox and
 * a QWidgetStack of the DataTables.
 *
 * This class serves as a "mediator" (see "Design Patterns") between the DataKiosk
 * class and the dataTable classes.  Thus all access to the dataTable classes from
 * non-DataTable related classes should be through the public API of this class.
 *
 * Unfortunately, it isn't working all that well for dataKiosk as opposed to Juk,
 * because sometimes the DataTables need access to the non-DataTable related classes.
 * This will be a focus of major refactoring during the port to Qt4/KDE4.
 */

class DataTableSplitter : public QSplitter
{
    Q_OBJECT

public:
    DataTableSplitter( QWidget *parent, const char *name = 0 );
    virtual ~DataTableSplitter();

    DataTableInterface *dataTable() const
    {
        return m_dataTableBox;
    }

private:

    DataTable *visibleDataTable() const
    {
        return m_dataTableBox->currentDataTable();
    }

    DataReport *visibleDataReport() const
    {
        return m_dataTableBox->currentDataReport();
    }

    void setupActions();
    void setupLayout();
    void readConfig();
    void saveConfig();

private slots:

    void slotShowSearchResults();
    void slotClearAdvancedSearchResults();
    void slotAdvancedSearchClicked();
    void slotAdvancedSearchChanged( const DataTableSearch & );
    void slotSearchEdited();
    void slotSearchRemoved();
    void slotDataTableChanged();

private:
    DataTableBox *m_dataTableBox;
    SearchWidget *m_searchWidget;
    QWidgetStack *m_dataTableStack;
};

#endif
