/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

/***************************************************************************
*   This file adapted from libkdepim kdateedit.h
*                                                                         *
*   Copyright (c) 2002 Cornelius Schumacher <schumacher@kde.org>          *
*   Copyright (c) 2003-2004 Reinhold Kainhofer <reinhold@kainhofer.com>   *
*   Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>                      *
*                                                                         *
***************************************************************************/

#ifndef DATEEDIT_H
#define DATEEDIT_H

#include <qdatetime.h>
#include <qmap.h>

#include "datatableeditorfactory.h"

class QEvent;
class QVBox;

class KDatePicker;

class DateEdit : public DataComboBox
{
    Q_OBJECT
    Q_PROPERTY( QDate date READ date WRITE setDate )
public:
    DateEdit( DataField* field, DataTable *dataTable,
              QWidget *parent = 0, const char *name = 0 );
    virtual ~DateEdit();

    QDate date() const;

    void setReadOnly( bool readOnly );
    bool isReadOnly() const;

    virtual void popup();

signals:
    void dateChanged( const QDate &date );

public slots:
    void setDate( const QDate &date );

protected slots:
    void lineEnterPressed();
    void slotTextChanged( const QString& );
    void dateEntered( QDate );
    void dateSelected( QDate );

protected:
    virtual bool eventFilter( QObject*, QEvent* );
    virtual void mousePressEvent( QMouseEvent* );

    void setupKeywords();

private:
    QDate parseDate( bool* = 0 ) const;
    void updateView();
    void assignDate( const QDate& );

    KDatePicker *mDatePicker;
    QVBox *mDateFrame;

    QDate mDate;
    bool mReadOnly;
    bool mTextChanged;
    bool mDiscardNextMousePress;

    QMap<QString, int> mKeywordMap;
};

#endif
