/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SEARCHWIDGET_H
#define SEARCHWIDGET_H

#include <ktoolbar.h>
#include <qhbox.h>

#include "datatablesearch.h"

class QCheckBox;
class KComboBox;
class KTextEdit;
class DataTable;
typedef QValueList<DataTableSearch> DataSearchList;

class SearchLine : public QHBox
{
    Q_OBJECT

public:

    SearchLine( QWidget *parent, DataTableList dataTables = DataTableList(),
                bool simple = false, const char *name = 0 );
    virtual ~SearchLine()
    {}

    DataTableSearch::Component searchComponent() const;
    void setSearchComponent( const DataTableSearch::Component &component );

    bool isPrompt() const;
    void setPrompt( bool prompt );

public slots:
    void clear();
    void searchFieldChanged();
    void setText( const QString &txt );

signals:
    void signalQueryChanged();
    void signalClearAdvancedQuery();

private:
    void updateColumns();

private:
    DataTableList m_dataTables;
    bool m_simple;
    bool m_calendarMode;
    KComboBox *m_searchFieldsBox;
    KComboBox *m_operator;
    QCheckBox *m_prompt;
    KLineEdit *m_lineEdit;
};

class AdvancedLine : public QHBox
{
    Q_OBJECT

public:

    AdvancedLine( QWidget *parent, DataTableList dataTables = DataTableList(),
                const char *name = 0 );
    virtual ~AdvancedLine()
    {}

    DataTableSearch::Component searchComponent() const;
    void setSearchComponent( const DataTableSearch::Component &component );

public slots:
    void clear();
    void searchTableChanged();

private:
    void updateTables();

private:
    DataTableList m_dataTables;
    KTextEdit *m_customSqlQuery;
    KComboBox *m_searchTablesBox;
};

class SearchWidget : public KToolBar
{
    Q_OBJECT

public:
    SearchWidget( QWidget *parent, const char *name = 0 );
    virtual ~SearchWidget();

    DataTableSearch createSearch( const DataTableList &dataTables ) const;
    DataTableSearch search() const;
    void setSearch( const DataTableSearch &search );
    DataSearchList searchList( const DataTableList &dataTables ) const;
    void setSearchList( const DataSearchList &searchList );
    void searchRemoved();

public slots:
    void clear();
    void setLineEnabled( bool enable );
    void setEnabled( bool enable );
    void searchListChanged();
    void invokeSearch( const QString &search );

signals:
    void signalQueryChanged();
    void signalClearAdvancedQuery();
    void signalSearchListChanged( const DataTableSearch &search );

    // This signal is only emitted when the Show/Hide action is triggered.
    // Minimizing/closing the DataKiosk window will not trigger this signal.

    void signalShown( bool shown );

private:
    void setupLayout();

private:
    SearchLine *m_searchLine;
    KComboBox *m_searchCombo;
    DataTableSearch m_search;
    DataSearchList m_searchList;
    QStringList m_columnHeaders;
};

#endif
