/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kaction.h>
#include <klocale.h>
#include <kdebug.h>

#include <qtooltip.h>
#include <qlayout.h>

#include "statuslabel.h"
#include "datatableinterface.h"
#include "actioncollection.h"

using namespace ActionCollection;

StatusLabel::StatusLabel( DataTableInterface *dataTable, QWidget *parent, const char *name ) :
        QHBox( parent, name ),
        DataTableObserver( dataTable )
{
    QFrame * frame = new QFrame( this );
    frame->setFrameStyle( Box | Sunken );
    frame->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding );

    // Make sure that we have enough of a margin to suffice for the borders,
    // hence the "lineWidth() * 2"
    QHBoxLayout *layout = new QHBoxLayout( frame,
                                           frame->lineWidth() * 2,
                                           5, "layout" );
    layout->addSpacing( 5 );

    m_left = new KSqueezedTextLabel( frame, "left" );
    layout->addWidget( m_left );
    m_left->setTextFormat( PlainText );
    m_left->setAlignment( AlignLeft | AlignVCenter );
    m_left->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding );

    m_right = new KSqueezedTextLabel( frame, "right" );
    layout->addWidget( m_right );
    m_right->setTextFormat( PlainText );
    m_right->setAlignment( AlignRight | AlignVCenter );
    m_right->setSizePolicy( QSizePolicy::Preferred, QSizePolicy::Expanding );

    layout->addSpacing( 5 );
}

StatusLabel::~StatusLabel()
{}

#include "statuslabel.moc"
