#include "OpticalFlow.H"

// -------------------------------------------------------------------

OpticalFlow::OpticalFlow(const char *src) {
  deleteSource = true ;
  source = ImageSource::create(src,Image::L) ;
  subscribeTo(source) ;
  source->start() ;
}

OpticalFlow::OpticalFlow(ImageSource *src, bool startSource) {
  deleteSource = false ;
  source = src ;
  subscribeTo(source) ;
  if (startSource) source->start() ;
}

// -------------------------------------------------------------------

void
OpticalFlow::handleFirstFrame(void) {
  std::cerr << "OpticalFlow::handleFirstFrame: " ;
  current.debug(std::cerr) ;
  std::cerr << std::endl ;
}

void OpticalFlow::updateFlow(void) {
  if (! (source->getFrameCount()%100))
    std::cerr << "OpticalFlow::updateFlow: " << source->getMeanRate() << " fps" << std::endl ;
}

void
OpticalFlow::react(Observable *obs) {
  if (obs==source) {
    Image tmp ;
    if (source->getNextImage(&tmp)) {
	 convertImage(&tmp, Image::L) ;
	 current.stealDataFrom(tmp) ;
	 if (source->getFrameCount()==1)
	   handleFirstFrame() ;
	 else
	   updateFlow() ;
	 previous.stealDataFrom(current) ;
    }
    notifyObservers() ;
  }
}

// -------------------------------------------------------------------

OpticalFlow::~OpticalFlow(void) {
  unsubscribeFrom(source) ;
  if (deleteSource) delete source ;
}
