#ifndef VideoViewer_H
#define VideoViewer_H

#include <nucleo/image/source/ImageSource.H>
#include <nucleo/gl/texture/glTexture.H>

#include <QGLWidget>

using namespace nucleo ;

class VideoViewer : public QGLWidget, public ReactiveObject {

Q_OBJECT

protected:

  ImageSource *source ;
  
  glTexture *texture ;

  void react(Observable *obs) ;

  void dragEnterEvent(QDragEnterEvent *event) ;
  void dropEvent(QDropEvent *event) ;

  void initializeGL(void) ;
  void paintGL(void) ;

protected slots:

  void setSource(QString) ;

public:

  VideoViewer(QString src) ;

  ~VideoViewer(void) ;

  QSize sizeHint(void) const ;

} ;


#endif
