#include <nucleo/nucleo.H>
#include <nucleo/utils/AppUtils.H>
#include <nucleo/core/ReactiveEngine.H>
#include <nucleo/image/source/ImageSource.H>
#include <nucleo/image/processing/difference/Difference.H>
#include <nucleo/image/sink/ImageSink.H>

using namespace nucleo ;

int
main(int argc, char **argv) {
  char *SRC = getenv("NUCLEO_SRC1") ;
  char *DST = "glwindow:?fps" ;
  if (parseCommandLine(argc, argv, "i:o:", "ss", &SRC, &DST)<0) {
	 std::cerr << std::endl << argv[0] << " [-i source] [-o sink]" << std::endl ;
	 exit(1) ;
  }

  ImageSource *source = ImageSource::create(SRC) ;
  source->start() ;

  Image img ;
  
  DifferenceFilter filter ;

  ImageSink *sink = ImageSink::create(DST) ;
  sink->start() ;
  
  while (source->isActive() && sink->isActive()) {
    ReactiveEngine::step() ;
    if (source->getNextImage(&img)) {
	 filter.filter(&img) ;
	 sink->handle(&img) ;
    }
  }
  
  delete source ;
  delete sink ;
}
