/*
 *
 * nucleo/apps/overlay.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.apps ;

import fr.lri.insitu.nucleo.nucleoException ;
import fr.lri.insitu.nucleo.image.source.AsyncImageSource ;
import fr.lri.insitu.nucleo.image.source.AsyncImageSourceEvent ;
import fr.lri.insitu.nucleo.image.source.AsyncImageSourceListener ;

import java.util.* ;
import javax.swing.*;
import java.awt.* ;
import java.awt.image.* ;
import java.awt.geom.* ;
import java.awt.event.* ;

// ------------------------------------------------------------------------------------------------------

public class overlay extends JFrame implements AsyncImageSourceListener, WindowListener, KeyListener {
    private AsyncImageSource isource1 = null, isource2 = null ;
    private BufferedImage img1 = null, img2 = null;
    private boolean firstImage = true ; 
    private float transparency = 0.5f ;

    public overlay(String u1, String u2) throws nucleoException {
	   super("overlay") ;
        JLabel label = new JLabel("Connecting...") ;
        label.setHorizontalAlignment(JLabel.CENTER) ;
        label.setBorder(BorderFactory.createMatteBorder(1,1,2,2,Color.black)) ;
        getContentPane().add(label, BorderLayout.CENTER) ;
	   setVisible(true) ;
	   pack() ;
	   show() ;
        addWindowListener(this) ;
	   addKeyListener(this) ;	   

	   isource1 = new AsyncImageSource(u1) ;
	   isource1.addListener(this) ;

	   isource2 = new AsyncImageSource(u2) ;
	   isource2.addListener(this) ;
    }

    public void handleImageSourceEvent(AsyncImageSourceEvent e) {
	   AsyncImageSource s = (AsyncImageSource)e.getSource() ;
	   if (s==isource1) img1 = e.getImage() ;
	   else if (s==isource2) img2 = e.getImage() ;

	   if (firstImage) {
		  Insets i = getInsets() ;
		  int w, h ;
		  if (img1!=null) { w=img1.getWidth() ; h=img1.getHeight() ; }
		  else { w=img2.getWidth() ; h=img2.getHeight() ; }
		  setSize(w+i.left+i.right,h+i.top+i.bottom) ;
	   }

	   repaint() ;
    }

    public void paint(Graphics g) {
	   if (img1==null && img2==null) {
		  // super.paint(g) ;
		  return ;
	   }

	   Graphics2D g2 = (Graphics2D) g ;

	   if (firstImage) {
		  g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED) ;
		  g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR) ;
		  firstImage = false ;
	   }

	   Insets i = getInsets() ;
	   Dimension d = getSize() ;
	   BufferedImage bi = (BufferedImage)createImage(d.width, d.height) ;
	   Graphics2D display = bi.createGraphics() ;

	   if (img1!=null) {
		  BufferedImageOp op=null ;
		  int w=img1.getWidth(), h=img1.getHeight() ;
		  double sx = (double)(d.width-i.left-i.right)/w ;
		  double sy = (double)(d.height-i.top-i.bottom)/h ;
		  if (sx!=1.0 || sy!=1.0) {
			 AffineTransform at = new AffineTransform() ;
			 AffineTransform sc = at.getScaleInstance(sx, sy) ;
			 op = new AffineTransformOp(sc, null) ;
		  }
		  display.drawImage(img1, op, i.left, i.top) ;
	   }

	   if (img2!=null) {
		  BufferedImageOp op=null ;
		  int w=img2.getWidth(), h=img2.getHeight() ;
		  double sx = (double)(d.width-i.left-i.right)/w ;
		  double sy = (double)(d.height-i.top-i.bottom)/h ;
		  if (sx!=1.0 || sy!=1.0) {
			 AffineTransform at = new AffineTransform() ;
			 AffineTransform sc = at.getScaleInstance(sx, sy) ;
			 op = new AffineTransformOp(sc, null) ;
		  }
			 
		  AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, transparency) ;
		  display.setComposite(ac) ;
		  display.drawImage(img2, op, i.left, i.top) ;
	   }

	   g2.drawImage(bi, 0, 0, this) ;
	   
    }

    // -----------------------------------------------------------------------------------------------

    public void windowClosing(WindowEvent e) { System.exit(0) ; }
    public void windowDeiconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}

    // -----------------------------------------------------------------------------------------------

    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode() ;
	   switch (keyCode) {
	   case KeyEvent.VK_ESCAPE: System.exit(0) ; break ;
	   case KeyEvent.VK_UP: if (transparency<=.99f) transparency += 0.01 ; break ;
	   case KeyEvent.VK_DOWN: if (transparency>=.01f) transparency -= 0.01 ; break ;
	   default: System.out.println(KeyEvent.getKeyText(keyCode)+" "+keyCode) ;
	   }
    }
    public void keyTyped(KeyEvent e) {}

    // -----------------------------------------------------------------------------------------------

    public static void main(String argv[]) throws nucleoException {
	   String u1 = "nudp://127.0.0.1:8989" ;
	   try { u1 = argv[0] ; } catch (Exception e) {}
	   String u2 = "nudp://127.0.0.1:8988" ;
	   try { u2 = argv[1] ; } catch (Exception e) {}
        final overlay o = new overlay(u1, u2) ;
    }

}
