/*
 *
 * nucleo/apps/testBridge.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.apps ;

import fr.lri.insitu.nucleo.nucleoException ;
import fr.lri.insitu.nucleo.image.source.ImageSource ;
import fr.lri.insitu.nucleo.image.source.ImageSourceFactory ;   
import fr.lri.insitu.nucleo.image.sink.ImageSink ;
import fr.lri.insitu.nucleo.image.sink.ImageSinkFactory ;

import java.net.URI ;
import java.awt.image.* ;

public class testBridge {

    public static void main(String argv[]) throws nucleoException, java.net.URISyntaxException {
	   URI uIn = new URI("nudp://127.0.0.1:8988") ;
	   URI uOut = new URI("nudp://127.0.0.1:8989") ;

	   ImageSink out = ImageSinkFactory.createSink(uOut) ;
	   ImageSource in = ImageSourceFactory.createSource(uIn) ;
	   for (;;) {
		  BufferedImage img = in.getLatestImage() ;
		  System.out.print(".") ;
		  out.handle(img) ;
	   }
    }

}
