/*
 *
 * nucleo/image/sink/nudpImageSink.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.image.sink ;

import fr.lri.insitu.nucleo.nucleoException ;

import java.net.* ;
import java.awt.image.* ;
import java.io.* ;
import com.sun.image.codec.jpeg.* ;

public class nudpImageSink extends ImageSink {

    private MulticastSocket imgSocket = null ;
    private InetAddress groupAddr = null ;
    private int port = 0 ;

    public nudpImageSink(String ga, int p) throws nucleoException {
	   try {
		  port = p ;
		  groupAddr = InetAddress.getByName(ga) ;
		  imgSocket = new MulticastSocket(port) ;
		  imgSocket.setSendBufferSize(65536) ;
		  // imgSocket.joinGroup(groupAddr) ;
	   } catch (Exception e) {
		  throw new nucleoException(e) ;		  
	   }
    }

    public void handle(BufferedImage img) {
	   try {
		  ByteArrayOutputStream out = new ByteArrayOutputStream(65536) ;
		  JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out) ;
		  encoder.encode(img) ;
		  byte[] buffer = out.toByteArray() ;

		  DatagramPacket packet = new DatagramPacket(buffer, buffer.length, groupAddr, port) ;
		  imgSocket.send(packet) ;
	   } catch (Exception e) {
		  System.out.println("nudpImageSink: "+e.toString()) ;
	   }
    }
}
