/*
 *
 * nucleo/image/source/AsyncImageSource.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.image.source ;

import fr.lri.insitu.nucleo.nucleoException ;

import java.net.URI ;
import java.util.* ;
import java.awt.image.* ;

public class AsyncImageSource implements Runnable {
    private URI uri = null ;
    private ImageSource source = null ;
    private Thread thread = null ;
    private BufferedImage image = null;
    private Vector listeners ;

    public AsyncImageSource(String u) throws nucleoException {
	   try {
		  uri = new URI(u) ;
		  source = ImageSourceFactory.createSource(uri) ;
		  thread = new Thread(this, "AsyncImageSource("+u+")") ;
		  thread.start() ;
	   } catch (Exception e) {
		  throw new nucleoException(e) ;
	   }
    }

    public void run() {
	   if (Thread.currentThread() == thread)
		  try {
			 while (true) {
				image = source.getLatestImage() ;
				if (listeners != null) {
				    AsyncImageSourceEvent ev = new AsyncImageSourceEvent(this, AsyncImageSourceEvent.NEW_IMAGE, image) ;
				    for (Enumeration e=listeners.elements(); e.hasMoreElements();)
					   ((AsyncImageSourceListener)e.nextElement()).handleImageSourceEvent(ev) ;
				}
			 }
		  } catch (Exception e) {
			 System.out.println(e.toString()) ;
		  }
    }

    public void addListener(AsyncImageSourceListener l) {
	   if (listeners==null) listeners = new Vector() ;
	   listeners.addElement(l) ;
    }

    public void removeListener(AsyncImageSourceListener l) {
	   if (listeners!=null) listeners.removeElement(l) ;
    }

}
