/*
 *
 * nucleo/image/source/AsyncImageSourceEvent.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.image.source ;

import java.util.* ;
import java.awt.image.* ;

public class AsyncImageSourceEvent extends EventObject {
    public static final int NEW_IMAGE = 1 ;
    public static final int SOURCE_STOPPED = 2 ;

    private BufferedImage image = null ;
    private int id ;

    AsyncImageSourceEvent(Object source, int i, BufferedImage img) {
	   super(source) ;
	   id = i ;
	   this.image = img ;
    }

    public int getID() { return id ; }
    public BufferedImage getImage() { return image ; }
}
