/*
 *
 * nucleo/image/source/ImageSourceFactory.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.image.source ;

import fr.lri.insitu.nucleo.nucleoException ;

import java.net.URI ;

public class ImageSourceFactory {  

    public static ImageSource createSource(String u) throws nucleoException {
	   try {
		  URI uri = new URI(u) ;
		  return createSource(uri) ;
	   } catch (Exception e) {
		  throw new nucleoException(e) ;
	   }
    }

    public static ImageSource createSource(URI uri) throws nucleoException {
	   String scheme = uri.getScheme() ;
	   int port = uri.getPort() ;

	   if (scheme.equals("nudpc")) {
		  if (port==-1) port = 5555 ;
		  return new nudpcImageSource(uri.getHost(), port,
								uri.getPath(), uri.getQuery()) ;
	   }

	   if (scheme.equals("nudp")) {
		  return new nudpImageSource(uri.getHost(), port) ;
	   }

	   if (scheme.equals("http")) {
		  if (port==-1) port = 80 ;
		  String request = uri.getPath() ;
		  String s = uri.getQuery() ;
		  if (s!=null) request = request + '?' + s ;
		  String fragment = uri.getFragment() ;
		  if (fragment!=null) request = request + '#' + fragment ;
		  return new httpImageSource(uri.getHost(), port, request) ;
	   }

	   throw new nucleoException("Unable to create an ImageSource from "+uri) ;
    }

}
