/*
 *
 * nucleo/image/source/httpImageSource.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.image.source ;

import fr.lri.insitu.nucleo.nucleoException ;
import fr.lri.insitu.nucleo.network.HttpMessage ;

import java.net.* ;
import java.awt.image.* ;
import java.io.* ;
import com.sun.image.codec.jpeg.* ;

public class httpImageSource extends ImageSource {

    private Socket imgSocket = null ;
    private InputStream input = null ;
    private HttpMessage message = null ;

    public httpImageSource(String host, int port, String r) throws nucleoException {
	   try {
		  imgSocket = new Socket(host, port) ;
		  OutputStream out = imgSocket.getOutputStream() ;
		  String request = "GET "+r+" HTTP/1.0\n\n" ;
		  out.write(request.getBytes()) ;
		  input = imgSocket.getInputStream() ;
		  message = new HttpMessage() ;
	   } catch (Exception e) {
		  throw new nucleoException(e) ;
	   }
    }

    public BufferedImage getLatestImage() throws nucleoException {
	   try {
		  for (int status=message.parse(); status!=HttpMessage.COMPLETE;) {
			 byte[] buffer = new byte[65536] ;
			 int bytesread = input.read(buffer) ;
			 message.feed(buffer, bytesread) ;
			 status = message.parse() ;
		  }
		  ByteArrayInputStream in = new ByteArrayInputStream(message.getBodyBytes()) ;
		  message.next() ;
		  JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder(in) ;
		  return decoder.decodeAsBufferedImage() ;
	   } catch (Exception e) {
		  throw new nucleoException(e) ;
	   }
    }
}
