/*
 *
 * nucleo/image/source/nudpImageSource.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.image.source ;

import fr.lri.insitu.nucleo.nucleoException ;

import java.net.* ;
import java.awt.image.* ;
import java.io.* ;
import com.sun.image.codec.jpeg.* ;

public class nudpImageSource extends ImageSource {

    private DatagramSocket imgSocket = null ;
    //    private MulticastSocket imgSocket = null ;

    public nudpImageSource(String groupAddr, int port) throws nucleoException {
	   try {
		  InetAddress group = InetAddress.getByName(groupAddr);
		  imgSocket = new MulticastSocket(port);
		  imgSocket.setReceiveBufferSize(65536) ;
		  //  imgSocket.joinGroup(group);
	   } catch (Exception e) {
		  throw new nucleoException(e) ;		  
	   }
    }

    public BufferedImage getLatestImage() {
	   try {
		  byte[] buffer = new byte[65536] ;
		  DatagramPacket packet = new DatagramPacket(buffer, 65536) ;
		  imgSocket.receive(packet) ;
		  ByteArrayInputStream in = new ByteArrayInputStream(buffer);
		  JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder(in);
		  return decoder.decodeAsBufferedImage();
	   } catch (Exception e) {
		  System.out.println("nudpImageSource: "+e.toString()) ;
	   }
	   return null ;
    }
}
