/*
 *
 * nucleo/image/source/nudpcImageSource.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.image.source ;

import fr.lri.insitu.nucleo.nucleoException ;

import java.net.* ;
import java.awt.image.* ;
import java.io.* ;
import com.sun.image.codec.jpeg.* ;

public class nudpcImageSource extends ImageSource {

    Socket videoServer = null ;
    private DatagramSocket imgSocket = null ;

    public nudpcImageSource(String host, int port, String path, String options) throws nucleoException {

	   try {
		  int lport = 0 ;

		  // Create a UDP socket to receive images
		  try {
			 imgSocket = new DatagramSocket() ;
		  } catch (Exception e) {
			 System.out.println("nudpcImageSource [DatagramSocket]: "+e.toString()) ;
		  }
		  imgSocket.setReceiveBufferSize(65536) ;
		  lport = imgSocket.getLocalPort() ;

		  // Create a TCP socket to send the HTTP request to the videoServer
		  String lhost = InetAddress.getLocalHost().getHostAddress() ;

		  String request = "/nudp" ;
		  if (path.equals("")) request = request + "/video" ; else request = request+path ;
		  request = request + "?nudp="+lhost+"%3A"+lport ;
		  if (options!=null) request = request+"&"+options ;

		  videoServer = new Socket(host, port) ;
		  OutputStream output = videoServer.getOutputStream() ;
		  String message = "GET "+request+" HTTP/1.0\n\n" ;
		  output.write(message.getBytes()) ;
	   } catch (Exception e) {
		  throw new nucleoException(e) ;
	   }
    }

    public BufferedImage getLatestImage() {
	   try {
		  byte[] buffer = new byte[65536] ;
		  DatagramPacket packet = new DatagramPacket(buffer, 65536) ;
		  imgSocket.receive(packet) ;
		  ByteArrayInputStream in = new ByteArrayInputStream(buffer);
		  JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder(in);
		  return decoder.decodeAsBufferedImage();
	   } catch (Exception e) {
		  System.out.println("nudpcImageSource: "+e.toString()) ;
	   }
	   return null ;
    }
}
