/*
 *
 * nucleo/swing/VideoPanel.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.swing ;

import fr.lri.insitu.nucleo.nucleoException ;
import fr.lri.insitu.nucleo.image.source.AsyncImageSource ;
import fr.lri.insitu.nucleo.image.source.AsyncImageSourceEvent ;
import fr.lri.insitu.nucleo.image.source.AsyncImageSourceListener ;

import javax.swing.*;
import java.awt.*;
import java.awt.image.* ;
import java.awt.geom.* ;

public class VideoPanel extends JPanel implements AsyncImageSourceListener {
    private AsyncImageSource isource = null ;
    private BufferedImage img = null ;
    private boolean firstImage = true ; 
    private Container container = null ;

    public VideoPanel(String u, Container c) throws nucleoException {
	   container = c ;
	   isource = new AsyncImageSource(u) ;
	   isource.addListener(this) ;	   
    }

    public void handleImageSourceEvent(AsyncImageSourceEvent e) {
	   img = e.getImage() ;
	   if (firstImage) {
		  int w=img.getWidth(), h=img.getHeight() ;
		  Insets i = getInsets() ;
		  container.setSize(w+i.left+i.right,h+i.top+i.bottom) ;
	   }
	   repaint() ;
    }

    public void paint(Graphics g) {
	   // super.paint(g) ;
	   if (img==null) return ;

	   Graphics2D g2 = (Graphics2D) g ;

	   if (firstImage) {
		  g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED) ;
		  // Might as weel use BICUBIC...
		  g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR) ;
		  firstImage = false ;
	   }

	   Insets i = getInsets() ;
	   int w=img.getWidth(), h=img.getHeight() ;
	   Dimension d = getSize() ;
	   BufferedImageOp op=null ;
	   double sx = (double)(d.width-i.left-i.right)/w ;
	   double sy = (double)(d.height-i.top-i.bottom)/h ;
	   if (sx!=1.0 || sy!=1.0) {
		  AffineTransform at = new AffineTransform() ;
		  AffineTransform sc = at.getScaleInstance(sx, sy) ;
		  op = new AffineTransformOp(sc, null) ;
	   }

	   g2.drawImage(img, op, i.left, i.top) ;
    }

}
