/**************************************************************************

    config.cpp  - MTaskBar config dialog
	Copyright (c) 2003 Sebastian Wolff

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to larrosa@kde.org

    changes (c) 2003 Sebastian Wolff

***************************************************************************/

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qvbuttongroup.h>
#include <qvgroupbox.h>
#include <qwidget.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qgrid.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qstringlist.h>
#include <qtextedit.h>

#include <kdialogbase.h>
#include <klocale.h>
#include <kconfig.h>
#include <kseparator.h>
#include <kapplication.h>
#include <kdebug.h>
#include <qspinbox.h>
#include <kcolorbutton.h>

#include "config.h"
#include "taskbarapplet.h"


MTaskBarConfigDialog::MTaskBarConfigDialog (MTaskbarApplet *parent)
 : KDialogBase ( 0, "configdialog", true, i18n("MTaskBar Settings"), Apply|Ok|Cancel, Ok, true )
{
    QVBox *box = new QVBox( this );
    //box->setSpacing(fontMetrics().lineSpacing());
	box->setSpacing(5);
    setMainWidget(box);
    m_parent = parent;
	box->setMinimumWidth(400);


	QVGroupBox * thumbbox = new QVGroupBox(i18n("Thumbnails"),box);
	m_chkShowThumbnails = new QCheckBox(i18n("Grab Screenshots"), thumbbox);
    connect(m_chkShowThumbnails, SIGNAL(toggled(bool)), this, SLOT(setShowThumbnails(bool)));
	QLabel *m_textlabel;
	QHBox *ttbox = new QHBox(thumbbox);
	ttbox->setSpacing(5);
	m_textlabel = new QLabel(i18n("<qt>Application exclude list (case sensitive: \"className,windowRole;\"):</qt>"), ttbox);
	m_txtExcludeList = new QTextEdit(ttbox);
	connect(m_txtExcludeList, SIGNAL(textChanged()), this, SLOT(setExcludeList()));
	m_txtExcludeList->setWrapPolicy(QTextEdit::AtWordOrDocumentBoundary);
	m_txtExcludeList->setWordWrap(QTextEdit::WidgetWidth);
	
	QVGroupBox * butbox = new QVGroupBox(box);
	QLabel *m_butlabel;
	QHBox *thbox = new QHBox(butbox);
	thbox->setSpacing(5);
	m_butlabel = new QLabel(i18n("Show Buttons"), thbox);
	m_chkShowButtons = new QComboBox(false, thbox);
	m_butlabel->setBuddy(m_chkShowButtons);
	m_chkShowButtons->insertItem(i18n("yes"));
	m_chkShowButtons->insertItem(i18n("on mouse hover and click"));
	m_chkShowButtons->insertItem(i18n("on click"));
	m_chkShowButtons->insertItem(i18n("never"));
    connect(m_chkShowButtons, SIGNAL(activated(int)), this, SLOT(setShowButtons(int)));
	
	m_chkSemiTransparentButtons = new QCheckBox(i18n("Semitransparent Buttons"), butbox);
    connect(m_chkSemiTransparentButtons, SIGNAL(toggled(bool)), this, SLOT(setSemiTransparentButtons(bool)));
	
    
	m_chkShowFrame = new QCheckBox(i18n("Show Frame"), box);
	connect(m_chkShowFrame, SIGNAL(toggled(bool)), this, SLOT(setShowFrame(bool)));
	m_chkShowTextGlow = new QCheckBox(i18n("Show Text Glow"), box);
    connect(m_chkShowTextGlow, SIGNAL(toggled(bool)), this, SLOT(setShowTextGlow(bool)));
	m_chkTextColor = new QCheckBox(i18n("Use window background color for text"), box);
    connect(m_chkTextColor, SIGNAL(toggled(bool)), this, SLOT(setTextColor(bool)));

	connect(this,SIGNAL(okClicked()),this,SLOT(slotOk()));
    connect(this,SIGNAL(applyClicked()),this,SLOT(slotApply()));
	loadConfiguration();
}


void MTaskBarConfigDialog::setShowButtons(int show)
{
    m_tmpShowButtons=show;
	enableButtonApply(true);
}
void MTaskBarConfigDialog::setShowThumbnails(bool show)
{
    m_tmpShowThumbnails=show;
	enableButtonApply(true);
}
void MTaskBarConfigDialog::setShowFrame(bool show)
{
    m_tmpShowFrame=show;
	enableButtonApply(true);
}
void MTaskBarConfigDialog::setShowTextGlow(bool show)
{
    m_tmpShowTextGlow=show;
	enableButtonApply(true);
}
void MTaskBarConfigDialog::setTextColor(bool show)
{
    m_tmpTextColor=show;
	enableButtonApply(true);
}
void MTaskBarConfigDialog::setSemiTransparentButtons(bool show)
{
	m_tmpSemiTransparentButtons=show;
	enableButtonApply(true);
}

void MTaskBarConfigDialog::setExcludeList()
{
	enableButtonApply(true);
	
	// check validity and remove unwanted characters:
	QString text = m_txtExcludeList->text();
	if (text.contains("\n") || text.contains("\t"))
	{
		text = text.remove("\n"); // remove any CR's
		text = text.remove("\t"); // remove any tabulators
		m_txtExcludeList->setText(text);
	}
}

void MTaskBarConfigDialog::setControlsFromConfig()
{
	m_chkShowButtons->setCurrentItem(m_tmpShowButtons);
	m_chkSemiTransparentButtons->setChecked(m_tmpSemiTransparentButtons);
	m_chkShowThumbnails->setChecked(m_tmpShowThumbnails);
	m_chkShowFrame->setChecked(m_tmpShowFrame);
	m_chkShowTextGlow->setChecked(m_tmpShowTextGlow);
	m_chkTextColor->setChecked(m_tmpTextColor);
	m_txtExcludeList->setText(m_excludeList);
}

void MTaskBarConfigDialog::loadConfiguration()
{
    m_tmpShowButtons=m_showButtons;
	m_tmpSemiTransparentButtons=m_semiTransparentButtons;
    m_tmpShowThumbnails=m_showThumbnails;
    m_tmpShowFrame=m_showFrame;
	m_tmpShowTextGlow=m_showTextGlow;
	m_tmpTextColor=m_textColor;
	setControlsFromConfig();
	enableButtonApply(false);
}

extern KConfig * mtaskbarglobalconfig;
void MTaskBarConfigDialog::initConfiguration(void)
{
	KConfig *cfg = mtaskbarglobalconfig;
	cfg->setGroup("MTaskBar");

	m_showButtons    =cfg->readNumEntry("showButtons", MTaskBarConfigDialog::c_defShowButtons);
	m_semiTransparentButtons =cfg->readBoolEntry("semiTransparentButtons", MTaskBarConfigDialog::c_defSemiTransparentButtons);
	m_showThumbnails =cfg->readBoolEntry("showThumbnails", MTaskBarConfigDialog::c_defShowThumbnails);
	m_showFrame      =cfg->readBoolEntry("showFrame", MTaskBarConfigDialog::c_defShowFrame);
	m_showTextGlow   =cfg->readBoolEntry("showTextGlow", MTaskBarConfigDialog::c_defShowTextGlow);
	m_textColor      =cfg->readBoolEntry("textColor", MTaskBarConfigDialog::c_defTextColor);

	QStringList slist = cfg->readListEntry("excludeList",";");
	m_excludeList=slist.join(";");
}

void MTaskBarConfigDialog::slotOk()
{
  slotApply();
  accept();
}

void MTaskBarConfigDialog::slotApply()
{
	enableButtonApply(false);

	// apply temporary values to global values
	m_showButtons=m_tmpShowButtons;
	m_showThumbnails=m_tmpShowThumbnails;
	m_showFrame=m_tmpShowFrame;
	m_showTextGlow=m_tmpShowTextGlow;
	m_textColor=m_tmpTextColor;
	m_semiTransparentButtons=m_tmpSemiTransparentButtons;
	
	m_excludeList = m_txtExcludeList->text();

	// save configuration
	m_parent->slotApplyConfigureFromDialog();
}

const int MTaskBarConfigDialog::c_defShowButtons=1;
const bool MTaskBarConfigDialog::c_defSemiTransparentButtons=false;
const bool MTaskBarConfigDialog::c_defShowThumbnails=true;
const bool MTaskBarConfigDialog::c_defShowFrame=false;
const bool MTaskBarConfigDialog::c_defShowTextGlow=true;
const bool MTaskBarConfigDialog::c_defTextColor=false;
const QString MTaskBarConfigDialog::c_defExcludeList="";
int MTaskBarConfigDialog::m_showButtons    = MTaskBarConfigDialog::c_defShowButtons;
bool MTaskBarConfigDialog::m_semiTransparentButtons = MTaskBarConfigDialog::c_defSemiTransparentButtons;
bool MTaskBarConfigDialog::m_showThumbnails = MTaskBarConfigDialog::c_defShowThumbnails;
bool MTaskBarConfigDialog::m_showFrame      = MTaskBarConfigDialog::c_defShowFrame;
bool MTaskBarConfigDialog::m_showTextGlow      = MTaskBarConfigDialog::c_defShowTextGlow;
bool MTaskBarConfigDialog::m_textColor      = MTaskBarConfigDialog::c_defTextColor;
QString MTaskBarConfigDialog::m_excludeList = MTaskBarConfigDialog::c_defExcludeList;


