/**************************************************************************

    config.h  - MTaskBar config dialog
	Copyright (c) 2003 Sebastian Wolff

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to larrosa@kde.org

    changes (c) 2003 Sebastian Wolff

***************************************************************************/
#ifndef __KPCONFIG_H
#define __KPCONFIG_H


#include <kdialogbase.h>

class QCheckBox;
class QButtonGroup;
class QRadioButton;
class QSpinBox;
class QComboBox;
class QTextEdit;
class MTaskbarApplet;

class MTaskBarConfigDialog : public KDialogBase
{
    Q_OBJECT

public:
    MTaskBarConfigDialog(MTaskbarApplet *parent);

public slots:
	void setShowButtons(int show);
	void setSemiTransparentButtons(bool show);
	void setShowThumbnails(bool show);
	void setShowFrame(bool show);
	void setShowTextGlow(bool show);
	void setTextColor(bool show);
	void setExcludeList();

    void loadConfiguration();
	void setControlsFromConfig();
    void slotOk();
    void slotApply();
public:
    static void initConfiguration(void);

	static int m_showButtons;
	static bool m_semiTransparentButtons;
    static bool m_showThumbnails;
	static bool m_showFrame;
	static bool m_showTextGlow;
	static bool m_textColor;
	static QString m_excludeList;

protected:
    MTaskbarApplet *m_parent;

	QComboBox *m_chkShowButtons;
	QCheckBox *m_chkShowThumbnails, *m_chkShowFrame, *m_chkShowTextGlow, *m_chkTextColor, *m_chkSemiTransparentButtons;
	QTextEdit * m_txtExcludeList;

    int m_tmpShowButtons; /* 0 = yes, 1 = on mouse hover and click, 2 = on mouse click, 3 = never */
	bool m_tmpSemiTransparentButtons;
    bool m_tmpShowThumbnails;
	bool m_tmpShowFrame;
	bool m_tmpShowTextGlow;
	bool m_tmpTextColor; /* false == textColor, true == standard Background */
	
	static const int c_defShowButtons;
	static const bool c_defSemiTransparentButtons;
	static const bool c_defShowThumbnails;
	static const bool c_defShowFrame;
	static const bool c_defShowTextGlow;
	static const bool c_defTextColor;
	static const QString c_defExcludeList;
};

#endif
