/*****************************************************************

Copyright (c) 2004 Sebastian Wolff

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <math.h>

#include <qlayout.h>
#include <qstringlist.h>

#include <kdebug.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kstandarddirs.h>
#include <klocale.h>

#include "config.h"
#include "taskbar.h"
#include "mtaskbar.h"
#include "mtaskbar.moc"
#include "mtaskcontainer.h"
#include "thumbnailmanager.h" 
#include "thumbnailanimation.h" 

#define WINDOWLISTBUTTON_SIZE 12

#define BUTTON_MIN_HEIGHT 18
#define BUTTON_HEIGHT 20
#define BUTTON_MAX_WIDTH 200
#define BUTTON_MIN_WIDTH 20

#include "qmessagebox.h"
MTaskBar::MTaskBar( QWidget *parent, const char *name )
    : TaskBar( parent, name )
{
    //qDebug("MTaskBar::MTaskBar");
//    setBackgroundMode(X11ParentRelative);
    setBackgroundOrigin( AncestorOrigin );
	m_anim_enabled  = true;
    
	delete manager;
	manager = 0;
	frames->clear();
	delete frames;
	containers.setAutoDelete(true);
	containers.clear();
	containers.setAutoDelete(false);
	
	

    setFrameStyle( NoFrame );

    arrowType = LeftArrow;
    blocklayout = TRUE;

    // init
    setMinimumSize( WINDOWLISTBUTTON_SIZE, WINDOWLISTBUTTON_SIZE );
    setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding ) );
    containers.setAutoDelete( FALSE );

    // setup animation frames
    frames = new PixmapList();

    frames->setAutoDelete( true );

    for ( int i=1; i<11; i++ )
		frames->append( new QPixmap( locate("data", "kicker/pics/disk" + QString::number(i) + ".png") ) );

    // configure
    configure();

    // connect manager
	// first the startup, then the tasks (to reduce layout flicker when startup is removed after the task pops up!) 
    connect( taskManager(), SIGNAL( startupAdded( Startup* ) ), SLOT( add( Startup* ) ) );
    connect( taskManager(), SIGNAL( startupRemoved( Startup* ) ), SLOT( remove( Startup* ) ) );
    connect( taskManager(), SIGNAL( taskAdded( Task* ) ), SLOT( add( Task* ) ) );
    connect( taskManager(), SIGNAL( taskRemoved( Task* ) ), SLOT( remove( Task* ) ) );
    connect( taskManager(), SIGNAL( desktopChanged( int ) ), SLOT( desktopChanged( int ) ) );
    connect( taskManager(), SIGNAL( windowChanged( WId ) ), SLOT( windowChanged( WId ) ) );

    isGrouping = shouldGroup();

    // register existant tasks
    TaskList tasks = taskManager()->tasks();
    for (Task* t = tasks.first(); t!=0; t = tasks.next())
		add( t );

    // register existant startups
    StartupList startups = taskManager()->startups();
    for (Startup* s = startups.first(); s!=0; s = startups.next())
		add( s );

    blocklayout = FALSE;
	
	m_anim = 0; 
	m_thumbman = 0;
	setThumbnailManager();
    //qDebug("MTaskBar::MTaskBar return");
}

MTaskBar::~MTaskBar()
{
}

void MTaskBar::setThumbnailManager()
{
	if (MTaskBarConfigDialog::m_showThumbnails)
	{
		if (!m_thumbman)
			m_thumbman = new ThumbnailManager(this);
		QStringList slist = QStringList::split(";",MTaskBarConfigDialog::m_excludeList);
		m_thumbman->setExcludeList(slist);
	}
	else
	{
		if (m_thumbman) 
		{
			delete m_thumbman;
			m_thumbman = 0;
		}
	}
}

void MTaskBar::add( Task* task )
{
    //qDebug("MTaskBar::add");
    if ( !task ) return;

    // try to group
    if ( isGrouping ) {
	for ( TaskContainerIterator it(containers); it.current(); ++it ) {
	    TaskContainer* c = it.current();

	    if ( idMatch( task->classClass().lower(), c->id().lower() ) ) {
		c->add( task );

		if ( !blocklayout )
		    reLayout();
		return;
	    }
	}
    }

    // create new container
    MTaskContainer *c = new MTaskContainer( task, taskManager(), this, showAllWindows, sortByDesktop, showIcon, showOnlyIconified, viewport() );
//TaskContainer *c = new TaskContainer( task, taskManager(), showAllWindows, sortByDesktop, showIcon, showOnlyIconified, viewport() );
    addChild( c );
    containers.append( c );

    if ( !blocklayout )
    {
        emit containerCountChanged();
	reLayout();
    }
    //qDebug("MTaskBar::add returned");
}

void MTaskBar::add( Startup* startup )
{
    if ( !startup ) return;

    // try to group
    if ( isGrouping ) {
	for ( TaskContainerIterator it(containers); it.current(); ++it ) {
	    TaskContainer* c = it.current();
	    if ( idMatch( startup->text().lower(), c->id().lower() ) ) {

		c->add( startup );

		if ( !blocklayout )
		    reLayout();
		return;
	    }
	}
    }

    // create new container
    MTaskContainer *c = new MTaskContainer( startup, frames, taskManager(), this, showAllWindows, sortByDesktop, showIcon, showOnlyIconified, viewport() );
    addChild( c );
    containers.append( c );

    if ( !blocklayout )
    {
        emit containerCountChanged();
	reLayout();
    }
}

void MTaskBar::animDelete()
{
    //qDebug("MTaskBar::animDelete");
	if (m_anim)
	{
		delete m_anim;
		m_anim = 0;
	}
}

void MTaskBar::animHide()
{
    //qDebug("MTaskBar::animHide");
	if (m_anim)
	{
		m_anim->unFocus();
	}
}

void MTaskBar::animNew(MTaskContainer *c)
{
    //qDebug("MTaskBar::animNew");
	animDelete();
	if (m_anim_enabled) 
		if (MTaskBarConfigDialog::m_showThumbnails)
		{
//qDebug("MTaskBar::animNew: sender = %s",c->getTasks().first()->name().latin1() );
			m_anim = new ThumbnailShiftAnimation(c,this);
		}
}

void MTaskBar::setAnimEnabled(bool enabled)
{
	m_anim_enabled = enabled;
	if (enabled)
	{
	}
	else
	{
		animDelete();
	}
}



