/*****************************************************************

Copyright (c) 2004 Sebastian Wolff

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __mtaskcontainer_h__
#define __mtaskcontainer_h__

#include <qptrlist.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qtimer.h>
#include <qtoolbutton.h>

#include "taskmanager.h"
#include "taskcontainer.h" 
#include "taskbar.h"

class LMBMenu;
class RMBMenu;
class MTaskContainer;
class MTaskBar;

typedef QPtrList<QPixmap> PixmapList;
typedef QPtrList<MTaskContainer> MTaskContainerList;
typedef QPtrListIterator<MTaskContainer> MTaskContainerListIterator;

class MTaskContainer : public TaskContainer
{
    Q_OBJECT

public:
    MTaskContainer( Task*, TaskManager*, MTaskBar *, bool show, bool sort, bool icon, bool iconifiedOnly, QWidget *parent = 0, const char *name = 0 );
    MTaskContainer( Startup*, PixmapList*, TaskManager*, MTaskBar *, bool show, bool sort, bool icon, bool iconifiedOnly, QWidget *parent = 0, const char *name = 0 );
    virtual ~MTaskContainer();

    virtual QString name();
	
	TaskList getTasks() {return tasks;}

	virtual void show();
	virtual void hide();
protected slots:
	virtual void slotFadeInOut();
	void slotOpenAnim();
    virtual void taskChanged();
	
protected:
    virtual void drawButton( QPainter* );
	virtual void paintEvent( QPaintEvent* );
	virtual bool event(QEvent *e);
	MTaskBar * m_taskbar;
	virtual void popupMenu( TaskBar::Action action );
	virtual void MTaskContainer::drawShadowText(QPainter  &p, QRect tr, int tf, const QString & str, int len = -1, QRect * brect = 0, QTextParag ** internal = 0 );

private:
	bool m_aboutToCloseAnim; // is true when we are closing the anim widget. During thatt operation we don't do any paint operations since it would flicker like nuts (workaroun for a maybe internal Qt bug)
	
	QTimer m_fadeinouttimer; 
	int m_fadeinoutcount;
	#define MTASKCONT_FADEINOUT_MAX 5
	
	
	//QPixmap old_icon;
	QString old_name;
	bool old_active;
	bool old_iconified;
	bool old_attention;
};

#endif
