//changed

/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qlayout.h>
#include <qstringlist.h>

#include <kapplication.h>
#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>

#include "taskbarcontainer.h"
#include "config.h"

#include "taskbarapplet.h"
#include "taskbarapplet.moc"


extern "C"
{
    KPanelApplet* init( QWidget *parent, const QString& configFile )
    {
        KGlobal::locale()->insertCatalogue( "TaskbarApplet" );
        MTaskbarApplet *taskbar = new MTaskbarApplet( configFile, KPanelApplet::Stretch,
                                                    KPanelApplet::Normal, parent, "TaskbarApplet" );
	return taskbar;
    }
}

MTaskbarApplet *mtaskbarapplet = 0;
KConfig * mtaskbarglobalconfig = 0;

MTaskbarApplet::MTaskbarApplet( const QString& configFile, Type type, int actions,
                             QWidget *parent, const char *name )
    : KPanelApplet( configFile, type, actions, parent, name )
      ,contextMenu(0)
{
//qDebug("MTaskbarApplet::MTaskbarApplet");
	mtaskbarglobalconfig = config();
	mtaskbarapplet = this;
    setBackgroundOrigin( AncestorOrigin );
//	setBackgroundMode(X11ParentRelative);
    _layout = new QHBoxLayout( this );
    container = new MTaskBarContainer( false, this );
    container->setBackgroundOrigin( AncestorOrigin );
    ((QHBoxLayout*)_layout)->addWidget( container, 1 );
	
	if (kapp->authorizeKAction("kicker_rmb"))
	{
		contextMenu = new QPopupMenu();
		connect(contextMenu, SIGNAL(aboutToShow()), SLOT(aboutToShowContextMenu()));
		setCustomMenu(contextMenu);
	}

	MTaskBarConfigDialog::initConfiguration(); // get config 
	slotApplyConfigureFromDialog(); // apply config 

//qDebug("MTaskbarApplet::MTaskbarApplet return");
}

MTaskbarApplet::~MTaskbarApplet()
{
}

int MTaskbarApplet::widthForHeight( int ) const
{
    return 200;
}

int MTaskbarApplet::heightForWidth( int ) const
{
    return 200;
}


void MTaskbarApplet::orientationChange( Orientation o )
{
    container->orientationChange( o );
}

void MTaskbarApplet::popupDirectionChange( Direction d )
{
    container->popupDirectionChange( d );
}

void MTaskbarApplet::slotApplyConfigureFromDialog()
{
	KConfig *cfg= mtaskbarglobalconfig;
	cfg->setGroup("MTaskBar");
	cfg->writeEntry("showButtons",MTaskBarConfigDialog::m_showButtons);
	cfg->writeEntry("semiTransparentButtons",MTaskBarConfigDialog::m_semiTransparentButtons);
	cfg->writeEntry("showThumbnails",MTaskBarConfigDialog::m_showThumbnails);
	cfg->writeEntry("showFrame",MTaskBarConfigDialog::m_showFrame);
	cfg->writeEntry("showTextGlow",MTaskBarConfigDialog::m_showTextGlow);
	cfg->writeEntry("textColor",MTaskBarConfigDialog::m_textColor);
	
	QStringList slist = QStringList::split(";",MTaskBarConfigDialog::m_excludeList);
	slist.sort();
	cfg->writeEntry("excludeList",slist,";");
	
	setUpdatesEnabled(false);
	if (_layout)
	{
		_layout->setMargin(MTaskBarConfigDialog::m_showFrame ? 1 : 0);
	}
	container->getTaskBar()->setFrameStyle(MTaskBarConfigDialog::m_showFrame ? QFrame::Plain  | QFrame::StyledPanel : NoFrame);
	container->getTaskBar()->setLineWidth(1);
	container->getTaskBar()->setThumbnailManager();
	setUpdatesEnabled(true);
	repaint();
	container->repaint();
	container->getTaskBar()->repaint();
	//update();
}

void MTaskbarApplet::slotPreferences()
{
	container->preferences();
}

void MTaskbarApplet::slotPreferences2()
{
	MTaskBarConfigDialog *dialog= new MTaskBarConfigDialog(this);
	if (dialog->exec())
	{
		slotApplyConfigureFromDialog();
	}
}

void MTaskbarApplet::aboutToShowContextMenu()
{
	// close animation widget!!! (else there is a kicker crash if we remove the taskbar!)
	container->getTaskBar()->animHide();

	
	contextMenu->clear();
	contextMenu->insertItem( i18n("&Configure Taskbar..."), this, SLOT(slotPreferences()) );
	contextMenu->insertItem( i18n("&Advanced Options..."), this, SLOT(slotPreferences2()) );
}

