/***************************************************************************
                          ball.cpp  -  Ball Class
                             -------------------
    begin                : Thu Oct 2 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 #include "foosball.hxx"

//	**************************************************************************************************************************
//
//                                              Move Ball appropriately
//
//	**************************************************************************************************************************

 void Ball::Move(Pitch &p)
 {
    unsigned int t = SGWGameClock();
    if (t-LastTick < 1000)
    {
        int Bounce = 0,x1,y1,n = t-LastTick;
        int yGoal = p.GoalSize();
        if (n < 10) return;
        x1 = x;y1 = y;
        x = x + xv * n / 1000;
        y = y + yv * n / 1000;
        if (abs(y) > YEXT)
        {
            yv = -yv;
            y = y + yv * n / 1000;
            Bounce = 1;
        }
        if (abs(x) > XEXT && abs(x1) <= XEXT && abs(y) > yGoal)
        {
            xv = -xv;
            Bounce = 1;
        }

        if (Bounce)
        {
            SGWBeep(b);
            b.SetPitch(64);
            b.On(100);
        }
        
        if (abs(xv) > XEXT/4 || abs(yv) > YEXT/4)
        {
            AdjustFriction(xv,n);
            AdjustFriction(yv,n);
        }
    }
    LastTick = t;
 }

//	**************************************************************************************************************************
//
//                                              Reset ball for kick off
//
//	**************************************************************************************************************************

 void Ball::ResetBall(void)
 {
    x = 0;y = 0;
    xv = yv = YEXT;
    if (rand()%2 == 0) xv = -xv;
    if (rand()%2 == 0) yv = -yv;
    LastTick = SGWGameClock();
 }

//	**************************************************************************************************************************
//
//                                     Kick the ball in a given direction
//
//	**************************************************************************************************************************

 void Ball::Kick(int xi,int yi,int Hard)
 {
    
    xv = xi * YEXT * 145 / 100;
    yv = yi * YEXT * 145 / 100 * 2 / 3;

    yv = yv + rand()%(YEXT/4)-YEXT/8;

    if (Hard)
    {
        xv = xv * 130/100;
        yv = yv * 130/100;
    }

    SGWBeep b;
    b.SetPitch(32);
    b.On(132);
 }

//	**************************************************************************************************************************
//
//                                     Adjust velocity for friction
//
//	**************************************************************************************************************************
    
void Ball::AdjustFriction(int &v,int n)
{
    double d = 0.9997;
    d = pow(d,(double)n);
    n = (int)(d*1000.0);
    v = v * n / 1000;
}

