/***************************************************************************
                      foosball.hxx  -  Foosball Include File
                             -------------------
    begin                : Wed Oct 1 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 #include <stdio.h>
 #include <stdlib.h>
 #include <math.h>
 #include "sgw.hxx"
 
 #define PLAYER1    (0)                         // Left to Right Player
 #define GOALIE1    (2)
 #define PLAYER2    (1)                         // Right to left Player
 #define GOALIE2    (3)
 #define BALL       (4)                         // Ball Graphic

 #define XEXT       (16384)                     // X Extent (+/-)
 #define YEXT       (8192)                      // Y Extent (+/-)
 #define MAXBARS    (4)                         // Max number of permitted bars


void GAMECreateGlobals(void);
void GAMEDestroyGlobals(void);
void GAMEPlay(int Def,int Mid,int Att,         // Formation (# players)
               int Cpu,int Speed,int Target);   // Cpu player, Speed (%), Target goals
              
 class Sprites : public SGWTransparentSurface
 {
    public:
        Sprites(int Size) : SGWTransparentSurface(Size * 5, Size * 5) { DrawSprites(Size); }
        int Size() { return SpriteSize; }
    protected:
        void DrawSprites(int Size);
        void DrawPlayer(int Swing,int xFlip);
    private:
        int SpriteSize;
 };
 
 enum BarState { Waiting, GoingBack, Holding, Kicking, ReturnCentre };
 enum Controller { Control1,Control2,Wandering, Tracking, Grabbed };
 enum PlayerStyle { Goalie, Defence, Midfield, Attack };

 class Pitch;
 class Ball;

 class Bar
 {
    public:
        Bar(int p,int d,enum PlayerStyle s,int x);
        void SetPlayers(int p) { Players = p;BarOffset = 0;BarLimit = (YEXT+GetYPos(0)); SetOffset(500);}
        void SetDirection(int d) { Direction = d; }
        void SetStyle(enum PlayerStyle s) { Style = s; }
        void SetPos(int p) { xPos = p; }
        void Draw(SGWSurface &s,Pitch &p);
        void DrawBack(void) { if (State == Waiting) SetState(GoingBack); }
        void KickForward(void) { if (State == Holding) SetState(Kicking); }
        int  GetXPos(void) { return xPos; }
        int  GetYPos(int n);
        void SetState(enum BarState s) { State = s;StateTimer.ResetTimer(50); }
        void SetController(enum Controller c);
        enum Controller GetController(void) { return Controller; }
        void SetOffset(int n);
        void Process(void);
        void Move(Ball &b);
        int  GetNearest(Ball &b);
        void GetKickDirection(int &x,int &y);
        int  GrabRadius(void) { return YEXT/8; }
    private:
        SGWTimer StateTimer;
        SGWTimer EventTimer;
        int Grabber;
        int BarOffset,BarLimit,BarPos,BarDir;
        unsigned int NextBarMove;
        int Swing;
        enum BarState State;
        enum Controller Controller;
        enum PlayerStyle Style;
        int Players;
        int Direction;
        int xPos;
 };

 class Pitch : public SGWSurface
 {
    public:
        Pitch(int xSize = 0,int ySize = 0) : SGWSurface(xSize,ySize)
                                        { SpriteGfx = new Sprites(Height()/8);RepaintPitch(); }
        virtual ~Pitch() { delete SpriteGfx; }
        void DrawAbsolute(SGWSurface &s,int x,int y,int Graphic,int Swing);
        void DrawLogical(SGWSurface &s,int x,int y,int Graphic,int Swing=0)
                            { if (Map(x,y)) DrawAbsolute(s,x,y,Graphic,Swing); }
        int  Map(int &x,int &y);
        int  GoalSize(void) { return YEXT*35/100; }
        void Copy(SGWSurface &s,int x,int y);
        void DrawBar(Bar &b);
        void RepaintPitch(void);
    protected:
        void GetPitchRectangle(SGWRect &r);
    private:
        Sprites *SpriteGfx;
        int  xScroll,yScroll;

 };

 class Team
 {
    public:
        Team(int Dir,int Def = 2,int Mid = 3,int Att = 3);
        ~Team();
        void Draw(SGWSurface &s,Pitch &p) { for (int i = 0;i < BarCount;i++) Bars[i]->Draw(s,p); }
        void Move(Ball &b) { for (int i = 0;i < BarCount;i++) Bars[i]->Move(b); }
        void DrawBars(Pitch &p) { for (int i = 0;i < BarCount;i++) p.DrawBar(*(Bars[i])); }
        void AutoPlay(Ball &b);
        int  GetActiveBar(Ball &b);
    protected:
        void AddBar(int xPos,int Size,enum PlayerStyle s);
    private:
        int BarCount;
        int Direction;
        Bar *Bars[MAXBARS];    
 };

 class Ball
 {
    public:
        Ball()  { ResetBall(); }
        void ResetBall(void);
        void Draw(SGWSurface &d,Pitch &p) { p.DrawLogical(d,x,y,BALL); }
        int  InGoal(void) { return (abs(x) > XEXT*17/16) ? x : 0; }
        int  GetX(void) { return x; }
        int  GetY(void) { return y; }
        int  GetXV(void) { return xv; }
        int  GetYV(void) { return yv; }
        int  Distance(int x1,int y1) { return (int)sqrt((double)(x-x1)*(x-x1)+(y-y1)*(y-y1)); }
        void Move(Pitch &p);
        void SetV(int x,int y) { xv = x;yv = y; }
        void SetPos(int x1,int y1) { x = x1;y = y1; }
        void Kick(int xi,int yi,int Hard);
        void AdjustFriction(int &v,int n);
    private:
        int x,y;
        int xv,yv;
        int LastTick;
 };

 class ScoreBoard : SGWTransparentSurface
 {
    public:
        ScoreBoard() : SGWTransparentSurface(DEFAULT_SCX/5,DEFAULT_SCY/7) { SetScore(0,0); }
        void Draw(SGWSurface &s) { Copy(s,DEFAULT_SCX/32,DEFAULT_SCY/32); }
        void SetScore(int s1,int s2) { Score[0] = s1;Score[1] = s2;RepaintScore(); }
        void BumpScore(int n);
        int  GetScore(int n) { return Score[n]; }
    protected:
        void RepaintScore(void);
    private:
        int  Score[2];
 };
