/***************************************************************************
                          game.cpp  -  an actual game
                             -------------------
    begin                : Thu Oct 9 2003 - yes I haven't worked on it for a while
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "foosball.hxx"

//  ********************************************************************************************************
//
//                                  Create and Destroy Global Objects
//
//  Before anyone lectures me about Globals, I'm creating some SDL Surfaces here, not piddly little memory
//  allocations, and I DONT think it's a good idea to continually create and destroy large objects even
//  under Linux - how reliable is the 'Surface Garbage Collection'. Classically, I know, things like the
//  Pitch surface should have scope in GAMEPlay(). 
//
//  ********************************************************************************************************

static Pitch *GPitch;
static ScoreBoard *GScoreBoard;

void GAMECreateGlobals(void)
{
    GPitch = new Pitch(1560,768);
    GScoreBoard = new ScoreBoard();
}

void GAMEDestroyGlobals(void)
{
    delete GPitch;
    delete GScoreBoard;
}

//  ********************************************************************************************************
//
//                                              Play ONE Game
//
//  ********************************************************************************************************

void GAMEPlay(int Def,int Mid,int Att,         
                      int Cpu,int Speed,int Target)
{
    SGWDisplaySurface Display;
    SGWBeep Beeper;
    Team Team1(1,Def,Mid,Att);                  // Create game objects
    Team Team2(-1,Def,Mid,Att);
    Ball b;
    int Quit = 0;
    SGWTimer Timer;

    SGWASSERT(GPitch != NULL);                  // Check globals
    SGWASSERT(GScoreBoard != NULL);
            
    SGWSetSpeed(Speed);                         // Game speed
    GPitch->RepaintPitch();                     // Redraw globals, pitch, score
    GScoreBoard->SetScore(0,0);
    Team1.DrawBars(*GPitch);
    Team2.DrawBars(*GPitch);
    
    while (GScoreBoard->GetScore(0) != Target   // Until game over or abandoned
                    && GScoreBoard->GetScore(1) != Target && Quit == 0)
    {
        b.ResetBall();                          // Start again
        GPitch->Copy(Display,b.GetX(),b.GetY());// Draw everything for kick off
        b.Draw(Display,*GPitch);
        Team1.Draw(Display,*GPitch);
        Team2.Draw(Display,*GPitch);
        GScoreBoard->Draw(Display);
        GPitch->Flip();
        Beeper.SetPitch(8);                     // Sound whistle... sort of.
        Timer.ResetTimer(600);                  // Okay, it sounds dire....
        Beeper.On();
        Timer.WaitTimer();
        Beeper.Off();
        b.ResetBall();
        
        while (Quit == 0 && b.InGoal() == 0)    // Main play loop
        {
            if (SGWExitKey()) Quit = 1;         // ESC quits
            Beeper.Tick();

            if (Cpu == 2) Team1.AutoPlay(b);    // Some control by CPU
            if (Cpu >= 1) Team2.AutoPlay(b);

            Team1.Move(b);                      // Move objects
            Team2.Move(b);
            b.Move(*GPitch);
                        
            GPitch->Copy(Display,               // Draw objects
                            b.GetX(),b.GetY());
            b.Draw(Display,*GPitch);
            Team1.Draw(Display,*GPitch);
            Team2.Draw(Display,*GPitch);
            GScoreBoard->Draw(Display);
            GPitch->Flip();
        }
        if (b.InGoal())                         // We've scored
        {
            GScoreBoard->BumpScore(b.InGoal()   // Bump score and redisplay
                                         > 0 ? 0 : 1);
            GPitch->Copy(Display,b.GetX(),b.GetY());
            Team1.Draw(Display,*GPitch);
            Team2.Draw(Display,*GPitch);
            GScoreBoard->Draw(Display);
            GPitch->Flip();
            Beeper.SetWhiteNoise();             // Make 'crowd noise'
            Timer.ResetTimer(1800);
            Beeper.On();
            while (!Timer.TimedOut()) {}
            Beeper.Off();            
        }        
    }    
}
