/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Wed Oct  1 14:06:28 BST 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "foosball.hxx"

static char *Start[] =   { "Play Game",NULL };
static char *Players[] = { "Player 1 v Player 2","Player 1 v CPU","Demo Game",NULL };
static char *Speeds[] =  { "Slow","Medium","Fast",NULL };
static char *Formation[]={ "Play 2-4-3","Play 3-3-3","Play 3-4-2","Play 4-2-3","Play 1-1-1",NULL };
static char *GameLen[] = { "3 Goals to Win","6 Goals to Win","9 Goals to Win",NULL };
static char *Exit[] =    { "Exit Game",NULL };

#define SELECTIONS (6)
static char **Menus[SELECTIONS] = { Start,Players,Speeds,Formation,GameLen,Exit };
static int  Selection[SELECTIONS];

static void GetMenuBox(int n,SGWRect &r)
{
    r.Left = 256;r.Right = 1024-r.Left;
    r.Top = 70*n+300;r.Bottom = r.Top+56;
}
int SGWMain(int argc,char *argv[])
{
    int i,x,y,Sel;
    char *s;
    SGWRect r;
    SGWDisplaySurface d;
    argc=argc;argv=argv;
    GAMECreateGlobals();                        // Create all the globals required (see game.cpp)
    for (i = 0;i < SELECTIONS;i++)              // Set up the standard selections
                            Selection[i] = 0;     
    Selection[2] = 1;                           // Default selection for speed is 'Medium'
    do
    {
            d.SetColour(0,0,0);d.FillRect();    // Draw it. I know, it's rubbish.
            d.SetColour(255,255,0);
            d.String(128,64,1024-128,192,"FOOSBALL");
            d.SetColour(0,255,0);
            d.String(64,220,1024-64,270,"Written by Paul Robson 2003");
            for (i = 0;i < SELECTIONS;i++)
            {
                GetMenuBox(i,r);
                d.SetColour(255,0,0);d.FillRect(r);
                d.SetColour(255,255,255);d.FrameRect(r);
                y = (r.Bottom-r.Top)/8;
                r.Top += y;r.Bottom -= y;
                s = Menus[i][Selection[i]];
                x = strlen(s)*(r.Bottom-r.Top)/2;
                r.Left = 512-x/2;r.Right = 512+x/2;
                d.SetColour(255,255,0);
                d.String(r,s);
                if (i != 0 && i != SELECTIONS-1)
                {
                    GetMenuBox(i,r);
                    r.Right = r.Left+r.Bottom-r.Top;
                    y = (r.Right-r.Left)/8;
                    r.Left += y;r.Right -= y;
                    r.Top += y;r.Bottom -= y;
                    d.SetColour(0,255,255);
                    d.FillEllipse(r);
                    d.SetColour(0,0,0);
                    d.FrameEllipse(r);
                }
            }
            d.Flip();
            SGWMouseClick(x,y);                 // Get a click and identify it.
            Sel = -1;
            for (i = 0;i < SELECTIONS;i++)
            {
                GetMenuBox(i,r);
                if (x > r.Left && x < r.Right && y > r.Top && y < r.Bottom) Sel = i;
            }
            switch(Sel)                         // Selected boxes.
            {
                case 0:                         // Play Game
                    s = Menus[3][Selection[3]]; // Find the formation to use
                    while (!isdigit(*s)) s++;   // Look for first number (I KNOW !)                    
                    GAMEPlay(s[0]-'0',s[2]-'0',s[4]-'0',
                             Selection[1],
                             80+Selection[2]*20,
                             Menus[4][Selection[4]][0]-'0');
                    break;
                case -1:                        // No selection or exit, do nothing
                case 5:
                    break;
                default:                        // Others just change it.
                    Selection[Sel]++;
                    if (Menus[Sel][Selection[Sel]] == NULL) Selection[Sel] = 0;
                    break;                   
            }
    } while (Sel != 5);                         // Until exited   
    GAMEDestroyGlobals();
    return 0;
}
    
char *SGWName(char *Name)
{
    strcpy(Name,"Foosball v0.9");
    return Name;
}
