/***************************************************************************
                          pitch.cpp  - Pitch Class
                             -------------------
    begin                : Wed Oct 1 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "foosball.hxx"

//  ********************************************************************************************************
//
//                                          Repaint the pitch
//
//  ********************************************************************************************************

void Pitch::RepaintPitch(void)
{
    SGWRect rPitch;
    SGWRect rGoal;
    int r,n;
    SetColour(0,0,255);FillRect();              // Fill
    GetPitchRectangle(rPitch);                  // Get the actual pitch size
    SetColour(0,128,0);FillRect(rPitch);        // Fill with green
    SetColour(255,255,255);FrameRect();         // Draw the white edges
    FrameRect(rPitch.Left-1,rPitch.Top-1,rPitch.Right+1,rPitch.Bottom+1);
    Line(Width()/2,rPitch.Top,                  // Centre line
                    Width()/2,rPitch.Bottom);
    r = Height()/8;                             // Centre circle
    FrameEllipse(Width()/2-r,Height()/2-r,Width()/2+r,Height()/2+r);
    r = r / 6;                                  // Kick off spot
    FillEllipse(Width()/2-r,Height()/2-r,Width()/2+r,Height()/2+r);
    
    r = (rPitch.Bottom-rPitch.Top)*GoalSize()/YEXT;  // Get goal position
    rGoal.Left = 0;rGoal.Right = rPitch.Left;
    rGoal.Top = Height()/2-r/2;rGoal.Bottom = Height()/2+r/2;
    SetColour(255,255,255);FillRect(rGoal);     // Draw frame
    SetColour(0,0,0);FrameRect(rGoal);
    r = (rGoal.Right-rGoal.Left)/16;            // Reduce to hashed area
    rGoal.Left += r;rGoal.Top += r;rGoal.Right -= r;rGoal.Bottom -= r;
    SetColour(64,64,64);FillRect(rGoal);
    SetColour(255,255,255);                     // Draw lines
    for (r = 1;r < 10;r++)
    {
        n = (rGoal.Bottom-rGoal.Top)*r/10+rGoal.Top;
        Line(rGoal.Left,n,rGoal.Right,n);
    }
    for (r = 1;r < 5;r++)
    {
        n = (rGoal.Right-rGoal.Left)*r/5+rGoal.Left;
        Line(n,rGoal.Top,n,rGoal.Bottom);
    }
    r = (rPitch.Bottom-rPitch.Top)*GoalSize()/YEXT;  // Get goal position
    rGoal.Left = 0;rGoal.Right = rPitch.Left;   
    rGoal.Top = Height()/2-r/2;rGoal.Bottom = Height()/2+r/2;
    SGWSurface::Copy(*this,rGoal,Width()-rGoal.Right,rGoal.Top);
    xScroll = yScroll = 0;
}

//  ********************************************************************************************************
//
//                              Get the part of the pitch actually played on.
//
//  ********************************************************************************************************

void Pitch::GetPitchRectangle(SGWRect &r)
{
    int vEdge = Height() / 64;
    int hEdge = Width() / 16;
    r.Left = hEdge;r.Top = vEdge;
    r.Right = Width()-hEdge-1;
    r.Bottom = Height()-vEdge-1;
}

//  ********************************************************************************************************
//
//                             Draw the players on the main display screen
//
//  ********************************************************************************************************

void Pitch::DrawAbsolute(SGWSurface &s,int x,int y,int Graphic,int Swing)
{
    int n = SpriteGfx->Size();
    SGWRect rc;
    SGWASSERT(Graphic >= 0 && Graphic < 5);
    SGWASSERT(Swing >= -2 && Swing <= 2);

    x = x - xScroll;y = y - yScroll;
    
    if (Graphic == BALL) Swing = -2;
    rc.Top = Graphic * n;rc.Left = (Swing+2) * n;
    rc.Right = rc.Left+n-1;rc.Bottom = rc.Top+n-1;
    SpriteGfx->Copy(s,rc,x-n/2,y-n/2);
}

//  ********************************************************************************************************
//
//                                  Map Physical to Logical Coordinate
//
//  ********************************************************************************************************

int Pitch::Map(int &x,int &y)
{
    SGWRect rc;
    GetPitchRectangle(rc);
    x = (rc.Right-rc.Left)*(x+XEXT)/(XEXT*2)+rc.Left;
    y = (rc.Bottom-rc.Top)*(-y+YEXT)/(YEXT*2)+rc.Top;
    return 1;
}

//  ********************************************************************************************************
//
//                               Copy the pitch to the given surface
//
//  ********************************************************************************************************

void Pitch::Copy(SGWSurface &s,int x,int y)
{
    SGWRect rc;
    Map(x,y);                                   // Convert to physical coordinates
    xScroll = x - s.Width()/2;
    yScroll = y - s.Height()/2;
    if (xScroll < 0) xScroll = 0;
    if (yScroll < 0) yScroll = 0;
    if (xScroll + s.Width() >= Width()) xScroll = Width()-s.Width();
    if (yScroll + s.Height() >= Height()) yScroll = Height()-s.Height();
    if (xScroll < 0) xScroll = 0;
    if (yScroll < 0) yScroll = 0;
   
    rc.Left = xScroll;rc.Right = xScroll+Width()-1;
    rc.Top = yScroll;rc.Bottom = yScroll+Height()-1;
    SGWSurface::Copy(s,rc,0,0);
}

//  ********************************************************************************************************
//
//                                          Draw a bar on the pitch
//
//  ********************************************************************************************************

void Pitch::DrawBar(Bar &b)
{
    SGWRect r;
    int x = b.GetXPos(), y = 0,w,n,c;
    Map(x,y);w = Width()/256;
    GetPitchRectangle(r);
    for (n = -w; n <= w;n++)
    {
        c = (w-abs(n))*128/w+127;
        SetColour(c,c,c);
        Line(x+n,r.Top,x+n,r.Bottom);
    
    }
}
