/***************************************************************************
                          score.cpp  -  description
                             -------------------
    begin                : Sat Oct 4 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "foosball.hxx"

//  ********************************************************************************************************
//
//                                          Scoreboard Repaint
//
//  ********************************************************************************************************
 
void ScoreBoard::RepaintScore(void)
{
    int s;
    SetColour();
    FillRect();
    for (int i = 0;i < 2;i++)
    {
        int w = Width()*40/100;
        SGWRect r(0,0,w,Height()*9/10);
        if (i == 1)
        {
            r.Left = Width()-r.Right-5;
            r.Right = r.Left+r.Right;
        }
        SetColour(0,0,0);
        Char(r,(char)(Score[i]+'0'));
        s = 4;r.Left+= s;r.Right+=s;r.Top+=s;r.Bottom+=s;
        SetColour(255,0,0);
        if (i == 1) SetColour(0,255,255);
        Char(r,(char)(Score[i]+'0'));
        if (i == 0)
        {
            r.Left = Width()/2-w/2;r.Right = r.Left+w;
            r.Top = 0;r.Bottom = Height()*9/10;
            SetColour(0,0,0);Char(r,':');
            r.Left+= s;r.Right+=s;r.Top+=s;r.Bottom+=s;
            SetColour(255,255,255);Char(r,':');
        }
    }
}

//  ********************************************************************************************************
//
//                                    Bump a score on the scorecard
//
//  ********************************************************************************************************

void ScoreBoard::BumpScore(int n)
{
    if (Score[n] < 9) Score[n]++;
    RepaintScore();
}
