/***************************************************************************
                    sprites.cpp  -  create game sprites
                             -------------------
    begin                : Wed Oct 1 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "foosball.hxx"

//  ********************************************************************************************************
//
//                          Draw Game sprites on transparent surface
//
//  ********************************************************************************************************

void Sprites::DrawSprites(int Size)
{
    int p,j,c;
    SpriteSize = Size;                          // Save size
    SetScale(Size,Size);                        // Makes 0-255 that size

    
    for (p = 0;p < 4;p++)                       // Work through each player
        for (j = 0;j < 5;j++)                   // 5 swing positions
    {
        SetOrigin(j*Size,p*Size);               // Set drawing position
        SetColour(255,0,0);                     // 0 is Red, facing right
        if (p == 1) SetColour(0,255,255);       // 1 is Cyan, facing left
        if (p >= 2) SetColour(0,255,0);       // 2 and 3 are goalies (right then left)
        DrawPlayer(j-2,(p == 0 || p == 2));      // Draw the player
    }
    SetOrigin(0,4*Size);                        // The Ball
    p = 84;

    for (j = p;j >= 0;j--)
    {
        c = 159+96*(p-j)/p;
        SetColour(c,c,0);
        FillEllipse(128-j,128-j,128+j,128+j);
    }
    SetColour(0,0,0);
    FrameEllipse(128-p,128-p,128+p,128+p);
}

//  ********************************************************************************************************
//
//                                          Draw one player
//
//  ********************************************************************************************************

void Sprites::DrawPlayer(int Swing,int xFlip)
{
    int Offset = Swing * 14;
    int Body = GetColour();
    int r,x,y;
    SGWRect rc;
    
    if (Swing != 0)                             // Legs and feet
    {
        rc.Left = (abs(Swing) == 2) ? 0 : 40;rc.Right = 128;
        rc.Top = 96;rc.Bottom = 160;
        if ((Swing < 0) ^ (xFlip != 0) != 0)
        {
            rc.Left = 255-rc.Left;rc.Right = 255-rc.Right;
        }
        SetColour(222,169,23);                  // Draw the legs
        FillRect(rc);
        SetColour(0,0,0);FrameRect(rc);
        Line(rc.Left,128,rc.Right,128);         // Line down the middle
        rc.Right = (rc.Right-rc.Left)/8+rc.Left;// Boots
        FillRect(rc);
    }
        
    r = -Swing*32;if (xFlip) r = -r;            // Shorts (white)
    SetColour(255,255,255);
    FillEllipse(98+r,64,158+r,192);
    SetColour(0,0,0);
    FrameEllipse(98+r,64,158+r,192);
    SetColour(255,255,255);
    FillRect(128,64,128+r,192);
    SetColour(0,0,0);
    Line(128,64,128+r,64);
    Line(128,192,128+r,192);

    if (xFlip) Offset = -Offset;                // Main body
    SetColour(Body);
    FillEllipse(98+Offset,64,158+Offset,192);
    FillEllipse(98-Offset,64,158-Offset,192);
    SetColour(0,0,0);
    FrameEllipse(98+Offset,64,158+Offset,192);
    FrameEllipse(98-Offset,64,158-Offset,192);
    if (Offset != 0)
    {
        SetColour(Body);
        FillRect(128-Offset,64,128+Offset,192);
        SetColour(0,0,0);
        Line(128-Offset,64,128+Offset,64);
        Line(128-Offset,192,128+Offset,192);
    }
    
    SetColour(128,64,0);                        // Head
    x = 128+Offset*4/3;y = 128;r = 44;
    FillEllipse(x-r,y-r,x+r,y+r);
    SetColour(0,0,0);
    FrameEllipse(x-r,y-r,x+r,y+r);
}
