/***************************************************************************
                           team.cpp  -  team class
                             -------------------
    begin                : Thu Oct 2 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "foosball.hxx"

//  ********************************************************************************************************
//
//                             Build a team to the given specifications
//
//  ********************************************************************************************************

Team::Team(int Dir,int Def,int Mid,int Att)
{
    BarCount = 0;
    Direction = Dir;
    AddBar(-XEXT*95/100*Dir,1,Goalie);
    if (Def > 0) AddBar(-XEXT*70/100*Dir,Def,Defence);
    if (Mid > 0) AddBar(-XEXT*15/100*Dir,Mid,Midfield);
    if (Att > 0) AddBar(XEXT*42/100*Dir,Att,Attack);
}

//  ********************************************************************************************************
//
//                      Destroy a team (should be method AppointGlennHoddle() ?)
//
//  ********************************************************************************************************

Team::~Team()
{
    for (int i = 0;i < BarCount;i++)
    {
        delete Bars[i];
        Bars[i] = NULL;
    }
    BarCount = 0;
}

//  ********************************************************************************************************
//
//                                    Add a bar - should be in order !
//
//  ********************************************************************************************************

void Team::AddBar(int xPos,int Size,enum PlayerStyle s)
{
    SGWASSERT(BarCount < MAXBARS);
    Bars[BarCount] = new Bar(Size,Direction,s,xPos);
    BarCount++;
}

//  ********************************************************************************************************
//
//                                  Set the computer playing tactics
//
//  ********************************************************************************************************

void Team::AutoPlay(Ball &b)
{
    enum Controller NewAction[MAXBARS];
    int i;
    for (i = 0;i < BarCount;i++)
        NewAction[i] = (Bars[i]->GetController() == Grabbed ? Grabbed : Wandering);

    i = GetActiveBar(b);
    if (NewAction[i] != Grabbed)
                NewAction[i] = Tracking;
    
    for (i = 0;i < BarCount;i++)
        if (Bars[i]->GetController() != NewAction[i])
                        Bars[i]->SetController(NewAction[i]);
}

//  ********************************************************************************************************
//
//                              Get the bar that is going to be used now
//
//  ********************************************************************************************************

int Team::GetActiveBar(Ball &b)
{
    int i,Active;
    int BallX = b.GetX()*Direction;

    if (b.GetXV()*Direction < 0)                // Ball going to the back, pick the one behind
    {
        Active = 0;
        for (i = 0;i < BarCount;i++)
            if (Bars[i]->GetXPos()*Direction <= BallX) Active = i;
    }
    else                                        // Ball going forward, pick the one in front
    {
        Active = -1;
        for (i = BarCount-1;i >= 0;i--)
            if (Bars[i]->GetXPos()*Direction >= BallX) Active = i;
    }

    return Active;
}


