//=== holds the tries number -------------------------------------------------
int lifesNumber = 8;

//=== holds the duplicated digits option -------------------------------------
bool NoDublication=1;

//=== the guessed number and secret number arrays -----------------------------
int  intGuessedNumber[4],SecretNumber[4];

//=== holds the result -------------------------------------------------------
int correctNumber=0,correctNumberAndPlace=0;

//=== the popular for() variables --------------------------------------------
int i,k;

//=== holds the current try number -------------------------------------------
int lifes=8;

//=== converted from the int array to be appended to QString -----------------
char chSecretNumber[4];

//***************************************************************************/
void GuessoForm::init()
{
	makeNumber();
	tView->setNumRows(lifesNumber);
	leInputNumbers->setFocus();
	lifes=lifesNumber;

//=== hide the Options section at the begining -------------------------------
	gbOptions->hide();
	line3->hide();
}

/******************************************************************************
** Changes the game difficulty
******************************/
void GuessoForm::setTriesNumber()
{
	int Ln = 8;
	
	if ( rbDefEasy->isChecked() )
	    Ln = 12;
	if ( rbDefNormal->isChecked() )
	    Ln = 8;
	if ( rbDefHard->isChecked() )
	    Ln = 5;
	
	lifesNumber=Ln;
	tView->setNumRows(lifesNumber);
	lifes=lifesNumber;
	restart();
	this->adjustSize();
}

/******************************************************************************
** Turns ON/OFF duplicated digitd in the secret number
*****************************************************/
void GuessoForm::setAllowDublicate(bool allow)
{
	if (allow == 1 ){
	NoDublication=0;
    }else if ( allow ==0 ){
	NoDublication=1;
    }
}

/******************************************************************************
** Proccess the guessed number and print the result
**************************************************/
void GuessoForm::start()
{
	tView->setText(lifesNumber-lifes,0,leInputNumbers->text());
	correctNumber=0;
	correctNumberAndPlace=0;
	setNumbers();
	compareNumbers();
	printScore();
	triesNumber();
}

/******************************************************************************
** Prepares the guessed number
*****************************/
void GuessoForm::setNumbers()
{
	int qGuessedNumbers = leInputNumbers->text().toInt();
	leInputNumbers->clear();
	// if qGuessedNumbers is 1234
	intGuessedNumber[0] = qGuessedNumbers/1000;                                 		 // 1234/1000 = 1
	intGuessedNumber[1] = qGuessedNumbers/100 - ( (qGuessedNumbers/1000) * 10) ;  	// 1234/100= 12 , 12 - 10 =2
	intGuessedNumber[2] = qGuessedNumbers/10  - ( (qGuessedNumbers/100) *10 );    // 1234/10=123 , 123 - 120=3
	intGuessedNumber[3] = qGuessedNumbers     - ( (qGuessedNumbers/10) *10);	// 1234 - 1230 = 4
}


/******************************************************************************
** Compare the secret and guessed numbers
*****************************************/
void GuessoForm::compareNumbers()
{
	int dontCompareK[4]={0,0,0,0};
	
	for (i=0;i<4;i++)			// loop the guessed number
	{
		for(k=0;k<4;k++)		// loop the secret number
		{
		    if (dontCompareK[k]!=1)	// don't repeat the result with the same secret number
		    {
			if ( intGuessedNumber[i] == SecretNumber[k] )
			{
				if ( i == k )
				{
					correctNumberAndPlace++;
					dontCompareK[k]=1;	// mark this digit
					break;
				}
				else
				{
					correctNumber++;
					dontCompareK[k]=1;	// mark this digit
					break;
				}
			}
		    }
		}
	}
}

/******************************************************************************
** Prints the result
*******************/
void GuessoForm::printScore()
{
	QString qScore;

	for (i=0;i<correctNumber;i++){
		qScore.append(' ');
		qScore.append('.');
	}

	for (i=1;i<=correctNumberAndPlace;i++){
		qScore.append(' ');
		qScore.append('o');
	}
	
	tView->setText(lifesNumber-lifes,1,qScore);
}

/******************************************************************************
** Tries number counter
**********************/
void GuessoForm::triesNumber()
{ 
	lifes--;
    // the user win
	if (correctNumberAndPlace == 4)
	{
		QString youWin = tr("Congratulations, You WON !! =)");
		tlStatus->setText(youWin);
		leInputNumbers->setEnabled(false);
	}else{
 // the user lost	
		if (lifes == 0 )
		{
			QString youLost;
			youLost = tr("You lost , the secret number was %1")
					.arg(chSecretNumber);
			
			tlStatus->setText(youLost);
			leInputNumbers->setEnabled(false);
		}
		else if ( lifes > 1 )
		{
			QString yourLifes;
			
			yourLifes = tr("You still have %1 tries")
					.arg(lifes);
			tlStatus->setText(yourLifes);
		}
		else if ( lifes == 1)
		{
			QString yourLife = tr("This is your last try, good luck") ;
			tlStatus->setText(yourLife);	
		}
	}
}

/******************************************************************************
** Prepares for a new game
*************************/
void GuessoForm::restart()
{
	if (correctNumberAndPlace != 4)
	{
		QString youLost;
		youLost = tr("You lost , the secret number was %1")
				.arg(chSecretNumber);
		
		tlStatus->setText(youLost);
	}
	for (i=0;i<4;i++)
	{
		intGuessedNumber[k]=0;
	}
	lifes = lifesNumber;
	correctNumber=0;
	correctNumberAndPlace=0;
	makeNumber();
	for (i=0;i<tView->numRows();i++)
		for (k=0;k<tView->numCols();k++)
			tView->clearCell(i,k);
	leInputNumbers->setEnabled(true);
}

/******************************************************************************
** Generates the random number
*****************************/
void GuessoForm::makeNumber()
{	
	srand((unsigned)time(0));
	int random_integer;
	for(i=0; i<4; i++)
	{
RANDOM:
		random_integer = (rand()%9)+1;
		if(NoDublication == 1)
		{
			for (k=0;k<4;k++)                             // this loop to make sure no duplecation numbers
				if ( random_integer == SecretNumber[k] )
					goto RANDOM;
		}
		SecretNumber[i]=random_integer;
	}
	//put SecretNumber into a string to be able to append it to QString
	sprintf( chSecretNumber, "%d%d%d%d", SecretNumber[0],SecretNumber[1],SecretNumber[2],SecretNumber[3] );

	cout << "SecretNumber:" << SecretNumber[0] << SecretNumber[1] << SecretNumber[2] << SecretNumber[3] << endl;
}

/******************************************************************************
** Shows the about dialoge
**************************/
void GuessoForm::showAbout()
{
	frmAbout w;
	w.exec();
}

/******************************************************************************
** Shows/Hides the options
**************************/
void GuessoForm::showHideOptions(bool direction)
{    
    if (direction== 1 )
    {
	gbOptions->show();
	line3->show();
	this->adjustSize();
	pbOptions->setText(tr("&Options <<"));
    }
    else if (direction == 0 )
    {
	gbOptions->hide();
	this->adjustSize();
	line3->hide();
	pbOptions->setText(tr("&Options >>"));
    }
}
