/**
 * This file is part of the System Preferences package
 * Copyright (C) 2005 Benjamin C Meyer (ben+systempreferences at meyerhome dot net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include "mainwindow.h"
#include "version.h"

int main( int argc, char **argv )
{
	// About data
  KAboutData aboutData("jukquiz", I18N_NOOP("Juk Quiz"), JUK_QUIZ_VERSION,
  I18N_NOOP("Musical quiz game."), KAboutData::License_LGPL, "(c) 2005, Benjamin C. Meyer",
  0, 0);
  aboutData.addAuthor("Benjamin C. Meyer", I18N_NOOP("Author"), "ben@meyerhome.net");
  KCmdLineArgs::init(argc, argv, &aboutData);
	
	
  KApplication a(argc, argv);

	MainWindow *mainWindow = new MainWindow;
	a.setMainWidget( mainWindow );
	mainWindow->show();
	
	return a.exec();
}

