/**
 * Copyright (C) 2003 Benjamin C Meyer (ben+jukquiz at meyerhome dot net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <kmainwindow.h>
#include <qptrlist.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qlayout.h>

class JukQuiz;
class QTimer;
class DCOPClient;
class QRadioButton;
class QVBoxLayout;

class MainWindow : public KMainWindow
{
	Q_OBJECT

public:
	MainWindow(QWidget *parent=0, const char *name=0);
	~MainWindow();

private slots:
	void playListSelected( const QString &selection );
	void selected( int selection );
	void nextSong();

	void timeOut();
	
	void loadSettings();
	void showSettings();
	void updateStats();
	
private:
	void saveScore();

	void makeChoiceList();
	void fillSong( const QString &filename, int number );
	QString trackProperties( const QString &filename, const QString &property ) const ;

	JukQuiz *mWidget;
	DCOPClient *client;
	QVBoxLayout *MainWidgetLayout;
	QTimer *timer;

	QStringList currentPlaylistSongs;
	uint currentSong;
	QPtrList<QRadioButton> list;
	QPtrList<QLabel> albumList;
	QPtrList<QLabel> albumCoverList;
	QPtrList<QGridLayout> trackLayouts;
	
	uint totalSongs;
	QVBoxLayout *songSelectionLayout;
	uint interval;
	
	// Score
	uint numberOfGames;
	uint numberOfWins;
	uint lengthToWin;

	bool jukHadPopup;
};

#endif // MAINWINDOW_H


