/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlcdnumber.h>
#include <qlabel.h>
#include <qfont.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qmap.h>
#include <qdir.h>

#include <klocale.h>
#include <kpushbutton.h>
#include <kmessagebox.h>

#include "solver.h"
#include "kaiketsu.h"

kaiketsu::kaiketsu()
    : Kaiketsuui( 0, "kaiketsu" )
{

  initSchemeEditor();
  initSchemeView("");

  m_pbClear->setText("Clear");
  m_pbSolve->setText("Solve");
  m_pbClear->setEnabled(true);
  m_pbSolve->setEnabled(true);
  m_pbStop->setEnabled(false);

 /* le[1]->setText("8");  le[5]->setText("6");
le[10]->setText("7"); le[14]->setText("3"); le[16]->setText("2"); 
le[20]->setText("4"); le[24]->setText("1"); 
le[27]->setText("9"); le[30]->setText("5"); le[33]->setText("4"); 
le[37]->setText("2"); le[40]->setText("8"); le[43]->setText("7");  
le[47]->setText("1"); le[53]->setText("6"); 
le[56]->setText("5"); le[60]->setText("9"); 
le[64]->setText("3"); le[66]->setText("4"); le[70]->setText("1");  
le[75]->setText("7");  le[79]->setText("8");*/

  s = new Solver(le, lcd,
                 m_lSteps,
                 m_lPartialSteps,
                 m_lLevel,
                 m_lSolutionsNumber);

  connect(m_pbClear, SIGNAL(clicked()), this, SLOT(slotClear()));
  connect(m_pbSolve, SIGNAL(clicked()), this, SLOT(slotSolve()));
  connect(m_pbStop, SIGNAL(clicked()), this, SLOT(slotStop()));
  connect(m_cbxSaveSolutions, SIGNAL(toggled(bool)), this, SLOT(slotSave(bool)));

}

kaiketsu::~kaiketsu()
{
  delete s;
  for(int i=0; i < 81; i++) {lcd[i] = 0; le[i] = 0;}
}

void kaiketsu::initSchemeView(const QString& v)
{
  lcd[0]=l1;
  lcd[1]=l2;
  lcd[2]=l3;
  lcd[3]=l4;
  lcd[4]=l5;
  lcd[5]=l6;
  lcd[6]=l7;
  lcd[7]=l8;
  lcd[8]=l9;
  lcd[9]=l10;
  lcd[10]=l11;
  lcd[11]=l12;
  lcd[12]=l13;
  lcd[13]=l14;
  lcd[14]=l15;
  lcd[15]=l16;
  lcd[16]=l17;
  lcd[17]=l18;
  lcd[18]=l19;
  lcd[19]=l20;
  lcd[20]=l21;
  lcd[21]=l22;
  lcd[22]=l23;
  lcd[23]=l24;
  lcd[24]=l25;
  lcd[25]=l26;
  lcd[26]=l27;
  lcd[27]=l28;
  lcd[28]=l29;
  lcd[29]=l30;
  lcd[30]=l31;
  lcd[31]=l32;
  lcd[32]=l33;
  lcd[33]=l34;
  lcd[34]=l35;
  lcd[35]=l36;
  lcd[36]=l37;
  lcd[37]=l38;
  lcd[38]=l39;
  lcd[39]=l40;
  lcd[40]=l41;
  lcd[41]=l42;
  lcd[42]=l43;
  lcd[43]=l44;
  lcd[44]=l45;
  lcd[45]=l46;
  lcd[46]=l47;
  lcd[47]=l48;
  lcd[48]=l49;
  lcd[49]=l50;
  lcd[50]=l51;
  lcd[51]=l52;
  lcd[52]=l53;
  lcd[53]=l54;
  lcd[54]=l55;
  lcd[55]=l56;
  lcd[56]=l57;
  lcd[57]=l58;
  lcd[58]=l59;
  lcd[59]=l60;
  lcd[60]=l61;
  lcd[61]=l62;
  lcd[62]=l63;
  lcd[63]=l64;
  lcd[64]=l65;
  lcd[65]=l66;
  lcd[66]=l67;
  lcd[67]=l68;
  lcd[68]=l69;
  lcd[69]=l70;
  lcd[70]=l71;
  lcd[71]=l72;
  lcd[72]=l73;
  lcd[73]=l74;
  lcd[74]=l75;
  lcd[75]=l76;
  lcd[76]=l77;
  lcd[77]=l78;
  lcd[78]=l79;
  lcd[79]=l80;
  lcd[80]=l81;

  QFont f("Sans Serif", 40, QFont::Bold);

  for(int i = 0; i < 81; i++)
    {
      lcd[i]->setText(v);

      lcd[i]->setFrameShape(QFrame::GroupBoxPanel);

      lcd[i]->setAlignment(Qt::AlignCenter);

      lcd[i]->setFont(f);
    }
}

void kaiketsu::initSchemeEditor()
{
  le[0]=le11;
  le[1]=le12;
  le[2]=le13;
  le[3]=le14;
  le[4]=le15;
  le[5]=le16;
  le[6]=le17;
  le[7]=le18;
  le[8]=le19;

  le[9]=le21;
  le[10]=le22;
  le[11]=le23;
  le[12]=le24;
  le[13]=le25;
  le[14]=le26;
  le[15]=le27;
  le[16]=le28;
  le[17]=le29;

  le[18]=le31;
  le[19]=le32;
  le[20]=le33;
  le[21]=le34;
  le[22]=le35;
  le[23]=le36;
  le[24]=le37;
  le[25]=le38;
  le[26]=le39;

  le[27]=le41;
  le[28]=le42;
  le[29]=le43;
  le[30]=le44;
  le[31]=le45;
  le[32]=le46;
  le[33]=le47;
  le[34]=le48;
  le[35]=le49;

  le[36]=le51;
  le[37]=le52;
  le[38]=le53;
  le[39]=le54;
  le[40]=le55;
  le[41]=le56;
  le[42]=le57;
  le[43]=le58;
  le[44]=le59;

  le[45]=le61;
  le[46]=le62;
  le[47]=le63;
  le[48]=le64;
  le[49]=le65;
  le[50]=le66;
  le[51]=le67;
  le[52]=le68;
  le[53]=le69;

  le[54]=le71;
  le[55]=le72;
  le[56]=le73;
  le[57]=le74;
  le[58]=le75;
  le[59]=le76;
  le[60]=le77;
  le[61]=le78;
  le[62]=le79;

  le[63]=le81;
  le[64]=le82;
  le[65]=le83;
  le[66]=le84;
  le[67]=le85;
  le[68]=le86;
  le[69]=le87;
  le[70]=le88;
  le[71]=le89;

  le[72]=le91;
  le[73]=le92;
  le[74]=le93;
  le[75]=le94;
  le[76]=le95;
  le[77]=le96;
  le[78]=le97;
  le[79]=le98;
  le[80]=le99;

  for(int i = 0; i < 80; i++) le[i]->setMaxLength(1);
}

void kaiketsu::freezeSchemeEditor(bool b)
{
  b = not b;
  for(int i = 0; i < 81; i++) le[i]->setEnabled(b);

}

void kaiketsu::clearSchemeEditor()
{
  for(int i = 0; i < 81; i++) le[i]->clear();
}

void kaiketsu::clearSchemeView()
{
  for(int i = 0; i < 81; i++)
    {
      if(le[i]->text() != "") lcd[i]->setBackgroundMode(Qt::PaletteBackground);
      lcd[i]->clear();
    }
}

void kaiketsu::slotClear()
{
  clearSchemeView();
  clearSchemeEditor();

  m_lSteps->setText("0");
  m_lPartialSteps->setText("0");
  m_lLevel->setText("0");
  m_lSolutionsNumber->setText("0");
}

void kaiketsu::slotSolve()
{
  m_pbClear->setEnabled(false);
  m_pbSolve->setEnabled(false);
  m_cbxSaveSolutions->setEnabled(false);
  m_pbStop->setEnabled(true);

  m_gbxSolver->setTitle("Solver");

  // If true then ends the recursion
  s->m_exitFlag = false;
  // Reads the scheme
  for(int i = 0; i < 81; i++)
    {
      QString t = le[i]->text();
      if(t == "") t = "?";
      s->append(t);
    }

  if(s->validateScheme())
    {
      clearSchemeView();

      freezeSchemeEditor(true);

      s->m_dbPath = m_leSolutionsDB->text();

      m_lSteps->setText("0");
      m_lPartialSteps->setText("0");
      m_lLevel->setText("0");
      m_lSolutionsNumber->setText("0");

      s->solve();

      m_gbxSolver->setTitle("Solver-showing last found valid solution");
      freezeSchemeEditor(false);

      if(s->m_exitFlag) showSolution();

    }
  else 
    {
      QString row(QString("ABCDEFGHI")[s->m_wrong.row]);
      uint column = s->m_wrong.column;
      QMap<uint, QString> columMap;
      columMap[0]="I";
      columMap[1]="II";
      columMap[2]="III";
      columMap[3]="IV";
      columMap[4]="V";
      columMap[5]="VI";
      columMap[6]="VII";
      columMap[7]="VIII";
      columMap[8]="IX";

      KMessageBox::error(this, i18n("Not a valid scheme. Please verify number at row %1, column %2.").arg(row).arg(columMap[column]));
    }
   s->clear();
   m_pbClear->setEnabled(true);
   m_pbSolve->setEnabled(true);
   m_cbxSaveSolutions->setEnabled(true);
   m_pbStop->setEnabled(false);

}

void kaiketsu::slotStop()
{
  s->emitSig(true);
}

void kaiketsu::slotSave(bool b)
{
  m_leSolutionsDB->setEnabled(b);
  QDir d;
  if(b) m_leSolutionsDB->setText(d.path()+"/solutions.txt");
  else m_leSolutionsDB->setText("");
}

void kaiketsu::slotRandom(bool b)
{
  s->emitSigRandom(b);
}

void kaiketsu::showSolution()
{
  s->printScheme();
}

#include "kaiketsu.moc"
