/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KAIKETSU_H_
#define _KAIKETSU_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qlcdnumber.h>
#include <qlineedit.h>
#include <qmap.h>

#include "kaiketsuui.h"
#include "casella.h"
#include "solver.h"

/**
 * @short Application Main Window
 * @author Emiliano Gulmini <emi_barbarossa@yahoo.it>
 * @version 0.1
 */
class kaiketsu : public Kaiketsuui
{
    Q_OBJECT

private:
  QLabel* lcd[81];
  QLineEdit* le[81];
  Solver* s;
  QMap<uint,bool> fixedNumbersMap;

public:
  /**
   * Default Constructor
   */
  kaiketsu();

  /**
   * Default Destructor
   */
  virtual ~kaiketsu();

public slots:
  void slotClear();
  void slotSolve();
  void slotStop();
  void slotSave(bool b);
  void slotRandom(bool b);
private:
  void initSchemeView(const QString& v);
  void initSchemeEditor();
  void freezeSchemeEditor(bool b);
  void clearSchemeEditor();
  void clearSchemeView();
  void showSolution();

};

#endif // _KAIKETSU_H_
