/*
  Copyright (C) 2005 by Bram Schoenmakers
  bramschoenmakers@kde.nl

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <qregexp.h>

#include <kapplication.h>
#include <kconfig.h>
#include <klocale.h>
#include <kglobal.h>
#include <kstandarddirs.h>

#include "cubescombo.h"

CubesCombo::CubesCombo( QWidget *parent, const char *name )
  : QComboBox( parent, name )
{
  setEditable( false );
  connect( this, SIGNAL( activated( int ) ), this, SLOT( writeSettings() ) );
}

CubesCombo::~CubesCombo()
{
}

void CubesCombo::readSettings()
{
  mCubeSets = KGlobal::dirs()->findAllResources( "data", "kboggle/cubes/*.cubes" );
  clear();

  for( uint i = 0 ; i < mCubeSets.count() ; ++i )
  {
    QString cubeSet = mCubeSets[ i ];
    mCubeSets[ i ] = cubeSet.remove( QRegExp( ".*cubes/" ) );
    mCubeSets[ i ] = mCubeSets[ i ].remove( ".cubes" );

    insertItem( KGlobal::locale()->twoAlphaToLanguageName( mCubeSets[ i ] ) );
  }

  KConfig *config = kapp->config();

  config->setGroup( "Localization" );
  QString lang = config->readEntry( "Cubeset", "en" );
  setCurrentItem( mCubeSets.findIndex( lang ) );
}

void CubesCombo::writeSettings()
{
  KConfig *config = kapp->config();
  config->setGroup( "Localization" );
  config->writeEntry( "Cubeset", mCubeSets[ currentItem() ] );

  config->sync();
}

#include "cubescombo.moc"
