/*
  Copyright (C) 2005 by Bram Schoenmakers
  bramschoenmakers@kde.nl

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef CUBESCOMBO_H
#define CUBESCOMBO_H

#include <qcombobox.h>

/**
  This combobox shows all available cube sets.
  @author Bram Schoenmakers <bramschoenmakers@kde.nl>
*/
class CubesCombo : public QComboBox
{
  Q_OBJECT
  public:
    CubesCombo( QWidget *parent = 0, const char *name = 0 );
    ~CubesCombo();

    QStringList cubeSets() const { return mCubeSets; }

    void readSettings();
  public slots:
    void writeSettings();

  private:
    QStringList mCubeSets;
};

#endif // CUBESCOMBO_H
