/*
  Copyright (C) 2005 by Bram Schoenmakers
  bramschoenmakers@kde.nl

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef GRID_H
#define GRID_H

#include "cell.h"

class QGridLayout;

/**
  This widget shows the grid with characters.
  @author Bram Schoenmakers <bramschoenmakers@kde.nl>
*/
class Grid : public QWidget
{
  Q_OBJECT
  public:
    Grid( KSpell *spell = 0, QWidget *parent = 0, const char *name = 0 );
    ~Grid();

    /** Returns the list of all possible words. */
    QStringList words() const { return mWords; }

    /** Returns true if the word appears in the grid */
    bool hasWord( const QString &, bool highlight = true );

    /**
      Sets the dimensions of the grid.
      Pre: @p width > 0 /\ @p height > 0
     */
    void setDimensions( int width, int height );

    void randomize();
    void setCharactersVisible( bool b );

    void setSpellChecker( KSpell *spell ) { mSpellChecker = spell; }

    void readSettings();

    void disableCells();

  public slots:
    void resetCells();

  signals:
    void appendChar( const QChar & );
    void removeChar( const QChar & );
    void submit();
    void clear();

  protected slots:
    /** Finds words with findWordsFrom(). */
    // void makeWordList( KSpell * );

    void appendChar( Cell * );
    void removeChar( Cell * );

  protected:
    /**
      Tries all combinations possible from cell @p cell.
      Pre: Spell checker is online
    */
    // void findWordsFrom( Cell *cell );
    QString composeWord( QPtrList<Cell> cells ) const;

    /**
      Returns a collection of cells which represent the given @p fullWord.
      The list is empty when there's not such a word in the grid
    */
    Cell::List *findMatchFrom( Cell *cell, QString whatsLeft, const QString &fullWord, bool newWord = true );

    // bool validateWord( const QString & ) const; // FIXME : Const?

    /** Highlights a cell for one second */
    void highlightCells( Cell::List * );

    /** Loads 16 cubes in @p cubes. These cubes are based on the current language setting. */
    void loadCubes( QStringList &cubes );

  private:
    Cell::List mCells;
    QStringList mWords;
    QGridLayout *mLayout;
    KSpell *mSpellChecker;

    int mRows;
    int mColumns;
    bool mShowChars;
    QString mCubeSet;
    bool mHighlightWords;
    bool mUseMouseEvents;

    Cell *mLastCell;
};

#endif
